/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApproximationDimension {
    SERVICE("SERVICE"),
    RESOURCE("RESOURCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApproximationDimension> VALUE_MAP;
    private final String value;

    private ApproximationDimension(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApproximationDimension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApproximationDimension> knownValues() {
        EnumSet<ApproximationDimension> knownValues = EnumSet.allOf(ApproximationDimension.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApproximationDimension.class, ApproximationDimension::toString);
    }
}

