/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SchemaElement {
    RESOURCES("RESOURCES"),
    SPLIT_COST_ALLOCATION_DATA("SPLIT_COST_ALLOCATION_DATA"),
    MANUAL_DISCOUNT_COMPATIBILITY("MANUAL_DISCOUNT_COMPATIBILITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SchemaElement> VALUE_MAP;
    private final String value;

    private SchemaElement(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SchemaElement fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SchemaElement> knownValues() {
        EnumSet<SchemaElement> knownValues = EnumSet.allOf(SchemaElement.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SchemaElement.class, SchemaElement::toString);
    }
}

