/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RemediationType {
    INHERITANCE_DRIFT("INHERITANCE_DRIFT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RemediationType> VALUE_MAP;
    private final String value;

    private RemediationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RemediationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RemediationType> knownValues() {
        EnumSet<RemediationType> knownValues = EnumSet.allOf(RemediationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RemediationType.class, RemediationType::toString);
    }
}

