/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controltower.model.ControlTowerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisableControlRequest
extends ControlTowerRequest
implements ToCopyableBuilder<Builder, DisableControlRequest> {
    private static final SdkField<String> CONTROL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlIdentifier").getter(DisableControlRequest.getter(DisableControlRequest::controlIdentifier)).setter(DisableControlRequest.setter(Builder::controlIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlIdentifier").build()}).build();
    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetIdentifier").getter(DisableControlRequest.getter(DisableControlRequest::targetIdentifier)).setter(DisableControlRequest.setter(Builder::targetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()}).build();
    private static final SdkField<String> ENABLED_CONTROL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enabledControlIdentifier").getter(DisableControlRequest.getter(DisableControlRequest::enabledControlIdentifier)).setter(DisableControlRequest.setter(Builder::enabledControlIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledControlIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_IDENTIFIER_FIELD, TARGET_IDENTIFIER_FIELD, ENABLED_CONTROL_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisableControlRequest.memberNameToFieldInitializer();
    private final String controlIdentifier;
    private final String targetIdentifier;
    private final String enabledControlIdentifier;

    private DisableControlRequest(BuilderImpl builder) {
        super(builder);
        this.controlIdentifier = builder.controlIdentifier;
        this.targetIdentifier = builder.targetIdentifier;
        this.enabledControlIdentifier = builder.enabledControlIdentifier;
    }

    public final String controlIdentifier() {
        return this.controlIdentifier;
    }

    public final String targetIdentifier() {
        return this.targetIdentifier;
    }

    public final String enabledControlIdentifier() {
        return this.enabledControlIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.controlIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledControlIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableControlRequest)) {
            return false;
        }
        DisableControlRequest other = (DisableControlRequest)((Object)obj);
        return Objects.equals(this.controlIdentifier(), other.controlIdentifier()) && Objects.equals(this.targetIdentifier(), other.targetIdentifier()) && Objects.equals(this.enabledControlIdentifier(), other.enabledControlIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"DisableControlRequest").add("ControlIdentifier", (Object)this.controlIdentifier()).add("TargetIdentifier", (Object)this.targetIdentifier()).add("EnabledControlIdentifier", (Object)this.enabledControlIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "controlIdentifier": {
                return Optional.ofNullable(clazz.cast(this.controlIdentifier()));
            }
            case "targetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetIdentifier()));
            }
            case "enabledControlIdentifier": {
                return Optional.ofNullable(clazz.cast(this.enabledControlIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("controlIdentifier", CONTROL_IDENTIFIER_FIELD);
        map.put("targetIdentifier", TARGET_IDENTIFIER_FIELD);
        map.put("enabledControlIdentifier", ENABLED_CONTROL_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisableControlRequest, T> g) {
        return obj -> g.apply((DisableControlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlTowerRequest.BuilderImpl
    implements Builder {
        private String controlIdentifier;
        private String targetIdentifier;
        private String enabledControlIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableControlRequest model) {
            super(model);
            this.controlIdentifier(model.controlIdentifier);
            this.targetIdentifier(model.targetIdentifier);
            this.enabledControlIdentifier(model.enabledControlIdentifier);
        }

        public final String getControlIdentifier() {
            return this.controlIdentifier;
        }

        public final void setControlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
        }

        @Override
        public final Builder controlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
            return this;
        }

        public final String getTargetIdentifier() {
            return this.targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        public final String getEnabledControlIdentifier() {
            return this.enabledControlIdentifier;
        }

        public final void setEnabledControlIdentifier(String enabledControlIdentifier) {
            this.enabledControlIdentifier = enabledControlIdentifier;
        }

        @Override
        public final Builder enabledControlIdentifier(String enabledControlIdentifier) {
            this.enabledControlIdentifier = enabledControlIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisableControlRequest build() {
            return new DisableControlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ControlTowerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisableControlRequest> {
        public Builder controlIdentifier(String var1);

        public Builder targetIdentifier(String var1);

        public Builder enabledControlIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

