/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ControlRelationType {
    COMPLEMENTARY("COMPLEMENTARY"),
    ALTERNATIVE("ALTERNATIVE"),
    MUTUALLY_EXCLUSIVE("MUTUALLY_EXCLUSIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ControlRelationType> VALUE_MAP;
    private final String value;

    private ControlRelationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ControlRelationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ControlRelationType> knownValues() {
        EnumSet<ControlRelationType> knownValues = EnumSet.allOf(ControlRelationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ControlRelationType.class, ControlRelationType::toString);
    }
}

