/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controlcatalog.model.ImplementationFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ControlFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ControlFilter> {
    private static final SdkField<ImplementationFilter> IMPLEMENTATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Implementations").getter(ControlFilter.getter(ControlFilter::implementations)).setter(ControlFilter.setter(Builder::implementations)).constructor(ImplementationFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Implementations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPLEMENTATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ControlFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ImplementationFilter implementations;

    private ControlFilter(BuilderImpl builder) {
        this.implementations = builder.implementations;
    }

    public final ImplementationFilter implementations() {
        return this.implementations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.implementations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlFilter)) {
            return false;
        }
        ControlFilter other = (ControlFilter)obj;
        return Objects.equals(this.implementations(), other.implementations());
    }

    public final String toString() {
        return ToString.builder((String)"ControlFilter").add("Implementations", (Object)this.implementations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Implementations": {
                return Optional.ofNullable(clazz.cast(this.implementations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<ImplementationFilter>> map = new HashMap<String, SdkField<ImplementationFilter>>();
        map.put("Implementations", IMPLEMENTATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ControlFilter, T> g) {
        return obj -> g.apply((ControlFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ImplementationFilter implementations;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlFilter model) {
            this.implementations(model.implementations);
        }

        public final ImplementationFilter.Builder getImplementations() {
            return this.implementations != null ? this.implementations.toBuilder() : null;
        }

        public final void setImplementations(ImplementationFilter.BuilderImpl implementations) {
            this.implementations = implementations != null ? implementations.build() : null;
        }

        @Override
        public final Builder implementations(ImplementationFilter implementations) {
            this.implementations = implementations;
            return this;
        }

        public ControlFilter build() {
            return new ControlFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ControlFilter> {
        public Builder implementations(ImplementationFilter var1);

        default public Builder implementations(Consumer<ImplementationFilter.Builder> implementations) {
            return this.implementations((ImplementationFilter)((ImplementationFilter.Builder)ImplementationFilter.builder().applyMutation(implementations)).build());
        }
    }
}

