/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controlcatalog.ControlCatalogClient;
import software.amazon.awssdk.services.controlcatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.controlcatalog.model.ControlMapping;
import software.amazon.awssdk.services.controlcatalog.model.ListControlMappingsRequest;
import software.amazon.awssdk.services.controlcatalog.model.ListControlMappingsResponse;

public class ListControlMappingsIterable
implements SdkIterable<ListControlMappingsResponse> {
    private final ControlCatalogClient client;
    private final ListControlMappingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListControlMappingsIterable(ControlCatalogClient client, ListControlMappingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListControlMappingsResponseFetcher();
    }

    public Iterator<ListControlMappingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ControlMapping> controlMappings() {
        Function<ListControlMappingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.controlMappings() != null) {
                return response.controlMappings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListControlMappingsResponseFetcher
    implements SyncPageFetcher<ListControlMappingsResponse> {
        private ListControlMappingsResponseFetcher() {
        }

        public boolean hasNextPage(ListControlMappingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListControlMappingsResponse nextPage(ListControlMappingsResponse previousPage) {
            if (previousPage == null) {
                return ListControlMappingsIterable.this.client.listControlMappings(ListControlMappingsIterable.this.firstRequest);
            }
            return ListControlMappingsIterable.this.client.listControlMappings((ListControlMappingsRequest)((Object)ListControlMappingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

