/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MappingType {
    FRAMEWORK("FRAMEWORK"),
    COMMON_CONTROL("COMMON_CONTROL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MappingType> VALUE_MAP;
    private final String value;

    private MappingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MappingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MappingType> knownValues() {
        EnumSet<MappingType> knownValues = EnumSet.allOf(MappingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MappingType.class, MappingType::toString);
    }
}

