/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controlcatalog.model.ControlCatalogResponse;
import software.amazon.awssdk.services.controlcatalog.model.ControlMapping;
import software.amazon.awssdk.services.controlcatalog.model.ControlMappingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListControlMappingsResponse
extends ControlCatalogResponse
implements ToCopyableBuilder<Builder, ListControlMappingsResponse> {
    private static final SdkField<List<ControlMapping>> CONTROL_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ControlMappings").getter(ListControlMappingsResponse.getter(ListControlMappingsResponse::controlMappings)).setter(ListControlMappingsResponse.setter(Builder::controlMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ControlMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListControlMappingsResponse.getter(ListControlMappingsResponse::nextToken)).setter(ListControlMappingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_MAPPINGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListControlMappingsResponse.memberNameToFieldInitializer();
    private final List<ControlMapping> controlMappings;
    private final String nextToken;

    private ListControlMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.controlMappings = builder.controlMappings;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasControlMappings() {
        return this.controlMappings != null && !(this.controlMappings instanceof SdkAutoConstructList);
    }

    public final List<ControlMapping> controlMappings() {
        return this.controlMappings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlMappings() ? this.controlMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListControlMappingsResponse)) {
            return false;
        }
        ListControlMappingsResponse other = (ListControlMappingsResponse)((Object)obj);
        return this.hasControlMappings() == other.hasControlMappings() && Objects.equals(this.controlMappings(), other.controlMappings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListControlMappingsResponse").add("ControlMappings", this.hasControlMappings() ? this.controlMappings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ControlMappings": {
                return Optional.ofNullable(clazz.cast(this.controlMappings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ControlMappings", CONTROL_MAPPINGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListControlMappingsResponse, T> g) {
        return obj -> g.apply((ListControlMappingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlCatalogResponse.BuilderImpl
    implements Builder {
        private List<ControlMapping> controlMappings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListControlMappingsResponse model) {
            super(model);
            this.controlMappings(model.controlMappings);
            this.nextToken(model.nextToken);
        }

        public final List<ControlMapping.Builder> getControlMappings() {
            List<ControlMapping.Builder> result = ControlMappingsCopier.copyToBuilder(this.controlMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlMappings(Collection<ControlMapping.BuilderImpl> controlMappings) {
            this.controlMappings = ControlMappingsCopier.copyFromBuilder(controlMappings);
        }

        @Override
        public final Builder controlMappings(Collection<ControlMapping> controlMappings) {
            this.controlMappings = ControlMappingsCopier.copy(controlMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlMappings(ControlMapping ... controlMappings) {
            this.controlMappings(Arrays.asList(controlMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlMappings(Consumer<ControlMapping.Builder> ... controlMappings) {
            this.controlMappings(Stream.of(controlMappings).map(c -> (ControlMapping)((ControlMapping.Builder)ControlMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListControlMappingsResponse build() {
            return new ListControlMappingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ControlCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListControlMappingsResponse> {
        public Builder controlMappings(Collection<ControlMapping> var1);

        public Builder controlMappings(ControlMapping ... var1);

        public Builder controlMappings(Consumer<ControlMapping.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

