/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controlcatalog.model.ImplementationIdentifierFilterListCopier;
import software.amazon.awssdk.services.controlcatalog.model.ImplementationTypeFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImplementationFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImplementationFilter> {
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Types").getter(ImplementationFilter.getter(ImplementationFilter::types)).setter(ImplementationFilter.setter(Builder::types)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Identifiers").getter(ImplementationFilter.getter(ImplementationFilter::identifiers)).setter(ImplementationFilter.setter(Builder::identifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPES_FIELD, IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImplementationFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> types;
    private final List<String> identifiers;

    private ImplementationFilter(BuilderImpl builder) {
        this.types = builder.types;
        this.identifiers = builder.identifiers;
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<String> types() {
        return this.types;
    }

    public final boolean hasIdentifiers() {
        return this.identifiers != null && !(this.identifiers instanceof SdkAutoConstructList);
    }

    public final List<String> identifiers() {
        return this.identifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentifiers() ? this.identifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImplementationFilter)) {
            return false;
        }
        ImplementationFilter other = (ImplementationFilter)obj;
        return this.hasTypes() == other.hasTypes() && Objects.equals(this.types(), other.types()) && this.hasIdentifiers() == other.hasIdentifiers() && Objects.equals(this.identifiers(), other.identifiers());
    }

    public final String toString() {
        return ToString.builder((String)"ImplementationFilter").add("Types", this.hasTypes() ? this.types() : null).add("Identifiers", this.hasIdentifiers() ? this.identifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Types": {
                return Optional.ofNullable(clazz.cast(this.types()));
            }
            case "Identifiers": {
                return Optional.ofNullable(clazz.cast(this.identifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("Types", TYPES_FIELD);
        map.put("Identifiers", IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImplementationFilter, T> g) {
        return obj -> g.apply((ImplementationFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> types = DefaultSdkAutoConstructList.getInstance();
        private List<String> identifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImplementationFilter model) {
            this.types(model.types);
            this.identifiers(model.identifiers);
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = ImplementationTypeFilterListCopier.copy(types);
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = ImplementationTypeFilterListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public final Collection<String> getIdentifiers() {
            if (this.identifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.identifiers;
        }

        public final void setIdentifiers(Collection<String> identifiers) {
            this.identifiers = ImplementationIdentifierFilterListCopier.copy(identifiers);
        }

        @Override
        public final Builder identifiers(Collection<String> identifiers) {
            this.identifiers = ImplementationIdentifierFilterListCopier.copy(identifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(String ... identifiers) {
            this.identifiers(Arrays.asList(identifiers));
            return this;
        }

        public ImplementationFilter build() {
            return new ImplementationFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImplementationFilter> {
        public Builder types(Collection<String> var1);

        public Builder types(String ... var1);

        public Builder identifiers(Collection<String> var1);

        public Builder identifiers(String ... var1);
    }
}

