/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcontactlens.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcontactlens.model.CategoryDetails;
import software.amazon.awssdk.services.connectcontactlens.model.MatchedCategoriesCopier;
import software.amazon.awssdk.services.connectcontactlens.model.MatchedDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Categories
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Categories> {
    private static final SdkField<List<String>> MATCHED_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchedCategories").getter(Categories.getter(Categories::matchedCategories)).setter(Categories.setter(Builder::matchedCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, CategoryDetails>> MATCHED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MatchedDetails").getter(Categories.getter(Categories::matchedDetails)).setter(Categories.setter(Builder::matchedDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CategoryDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCHED_CATEGORIES_FIELD, MATCHED_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Categories.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> matchedCategories;
    private final Map<String, CategoryDetails> matchedDetails;

    private Categories(BuilderImpl builder) {
        this.matchedCategories = builder.matchedCategories;
        this.matchedDetails = builder.matchedDetails;
    }

    public final boolean hasMatchedCategories() {
        return this.matchedCategories != null && !(this.matchedCategories instanceof SdkAutoConstructList);
    }

    public final List<String> matchedCategories() {
        return this.matchedCategories;
    }

    public final boolean hasMatchedDetails() {
        return this.matchedDetails != null && !(this.matchedDetails instanceof SdkAutoConstructMap);
    }

    public final Map<String, CategoryDetails> matchedDetails() {
        return this.matchedDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchedCategories() ? this.matchedCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchedDetails() ? this.matchedDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Categories)) {
            return false;
        }
        Categories other = (Categories)obj;
        return this.hasMatchedCategories() == other.hasMatchedCategories() && Objects.equals(this.matchedCategories(), other.matchedCategories()) && this.hasMatchedDetails() == other.hasMatchedDetails() && Objects.equals(this.matchedDetails(), other.matchedDetails());
    }

    public final String toString() {
        return ToString.builder((String)"Categories").add("MatchedCategories", this.hasMatchedCategories() ? this.matchedCategories() : null).add("MatchedDetails", this.hasMatchedDetails() ? this.matchedDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MatchedCategories": {
                return Optional.ofNullable(clazz.cast(this.matchedCategories()));
            }
            case "MatchedDetails": {
                return Optional.ofNullable(clazz.cast(this.matchedDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MatchedCategories", MATCHED_CATEGORIES_FIELD);
        map.put("MatchedDetails", MATCHED_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Categories, T> g) {
        return obj -> g.apply((Categories)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> matchedCategories = DefaultSdkAutoConstructList.getInstance();
        private Map<String, CategoryDetails> matchedDetails = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Categories model) {
            this.matchedCategories(model.matchedCategories);
            this.matchedDetails(model.matchedDetails);
        }

        public final Collection<String> getMatchedCategories() {
            if (this.matchedCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchedCategories;
        }

        public final void setMatchedCategories(Collection<String> matchedCategories) {
            this.matchedCategories = MatchedCategoriesCopier.copy(matchedCategories);
        }

        @Override
        public final Builder matchedCategories(Collection<String> matchedCategories) {
            this.matchedCategories = MatchedCategoriesCopier.copy(matchedCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedCategories(String ... matchedCategories) {
            this.matchedCategories(Arrays.asList(matchedCategories));
            return this;
        }

        public final Map<String, CategoryDetails.Builder> getMatchedDetails() {
            Map<String, CategoryDetails.Builder> result = MatchedDetailsCopier.copyToBuilder(this.matchedDetails);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMatchedDetails(Map<String, CategoryDetails.BuilderImpl> matchedDetails) {
            this.matchedDetails = MatchedDetailsCopier.copyFromBuilder(matchedDetails);
        }

        @Override
        public final Builder matchedDetails(Map<String, CategoryDetails> matchedDetails) {
            this.matchedDetails = MatchedDetailsCopier.copy(matchedDetails);
            return this;
        }

        public Categories build() {
            return new Categories(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Categories> {
        public Builder matchedCategories(Collection<String> var1);

        public Builder matchedCategories(String ... var1);

        public Builder matchedDetails(Map<String, CategoryDetails> var1);
    }
}

