/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.BatchGetCaseRuleResponseCaseRulesListCopier;
import software.amazon.awssdk.services.connectcases.model.BatchGetCaseRuleResponseErrorsListCopier;
import software.amazon.awssdk.services.connectcases.model.BatchGetCaseRuleResponseUnprocessedCaseRulesListCopier;
import software.amazon.awssdk.services.connectcases.model.CaseRuleError;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesResponse;
import software.amazon.awssdk.services.connectcases.model.GetCaseRuleResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCaseRuleResponse
extends ConnectCasesResponse
implements ToCopyableBuilder<Builder, BatchGetCaseRuleResponse> {
    private static final SdkField<List<GetCaseRuleResponse>> CASE_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("caseRules").getter(BatchGetCaseRuleResponse.getter(BatchGetCaseRuleResponse::caseRules)).setter(BatchGetCaseRuleResponse.setter(Builder::caseRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetCaseRuleResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CaseRuleError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetCaseRuleResponse.getter(BatchGetCaseRuleResponse::errors)).setter(BatchGetCaseRuleResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaseRuleError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> UNPROCESSED_CASE_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("unprocessedCaseRules").getter(BatchGetCaseRuleResponse.getter(BatchGetCaseRuleResponse::unprocessedCaseRules)).setter(BatchGetCaseRuleResponse.setter(Builder::unprocessedCaseRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedCaseRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_RULES_FIELD, ERRORS_FIELD, UNPROCESSED_CASE_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetCaseRuleResponse.memberNameToFieldInitializer();
    private final List<GetCaseRuleResponse> caseRules;
    private final List<CaseRuleError> errors;
    private final List<String> unprocessedCaseRules;

    private BatchGetCaseRuleResponse(BuilderImpl builder) {
        super(builder);
        this.caseRules = builder.caseRules;
        this.errors = builder.errors;
        this.unprocessedCaseRules = builder.unprocessedCaseRules;
    }

    public final boolean hasCaseRules() {
        return this.caseRules != null && !(this.caseRules instanceof SdkAutoConstructList);
    }

    public final List<GetCaseRuleResponse> caseRules() {
        return this.caseRules;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<CaseRuleError> errors() {
        return this.errors;
    }

    public final boolean hasUnprocessedCaseRules() {
        return this.unprocessedCaseRules != null && !(this.unprocessedCaseRules instanceof SdkAutoConstructList);
    }

    public final List<String> unprocessedCaseRules() {
        return this.unprocessedCaseRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCaseRules() ? this.caseRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedCaseRules() ? this.unprocessedCaseRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCaseRuleResponse)) {
            return false;
        }
        BatchGetCaseRuleResponse other = (BatchGetCaseRuleResponse)((Object)obj);
        return this.hasCaseRules() == other.hasCaseRules() && Objects.equals(this.caseRules(), other.caseRules()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasUnprocessedCaseRules() == other.hasUnprocessedCaseRules() && Objects.equals(this.unprocessedCaseRules(), other.unprocessedCaseRules());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCaseRuleResponse").add("CaseRules", this.hasCaseRules() ? this.caseRules() : null).add("Errors", this.hasErrors() ? this.errors() : null).add("UnprocessedCaseRules", this.hasUnprocessedCaseRules() ? this.unprocessedCaseRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseRules": {
                return Optional.ofNullable(clazz.cast(this.caseRules()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "unprocessedCaseRules": {
                return Optional.ofNullable(clazz.cast(this.unprocessedCaseRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("caseRules", CASE_RULES_FIELD);
        map.put("errors", ERRORS_FIELD);
        map.put("unprocessedCaseRules", UNPROCESSED_CASE_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCaseRuleResponse, T> g) {
        return obj -> g.apply((BatchGetCaseRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesResponse.BuilderImpl
    implements Builder {
        private List<GetCaseRuleResponse> caseRules = DefaultSdkAutoConstructList.getInstance();
        private List<CaseRuleError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<String> unprocessedCaseRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCaseRuleResponse model) {
            super(model);
            this.caseRules(model.caseRules);
            this.errors(model.errors);
            this.unprocessedCaseRules(model.unprocessedCaseRules);
        }

        public final List<GetCaseRuleResponse.Builder> getCaseRules() {
            List<GetCaseRuleResponse.Builder> result = BatchGetCaseRuleResponseCaseRulesListCopier.copyToBuilder(this.caseRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCaseRules(Collection<GetCaseRuleResponse.BuilderImpl> caseRules) {
            this.caseRules = BatchGetCaseRuleResponseCaseRulesListCopier.copyFromBuilder(caseRules);
        }

        @Override
        public final Builder caseRules(Collection<GetCaseRuleResponse> caseRules) {
            this.caseRules = BatchGetCaseRuleResponseCaseRulesListCopier.copy(caseRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseRules(GetCaseRuleResponse ... caseRules) {
            this.caseRules(Arrays.asList(caseRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseRules(Consumer<GetCaseRuleResponse.Builder> ... caseRules) {
            this.caseRules(Stream.of(caseRules).map(c -> (GetCaseRuleResponse)((GetCaseRuleResponse.Builder)GetCaseRuleResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CaseRuleError.Builder> getErrors() {
            List<CaseRuleError.Builder> result = BatchGetCaseRuleResponseErrorsListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<CaseRuleError.BuilderImpl> errors) {
            this.errors = BatchGetCaseRuleResponseErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<CaseRuleError> errors) {
            this.errors = BatchGetCaseRuleResponseErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(CaseRuleError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<CaseRuleError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (CaseRuleError)((CaseRuleError.Builder)CaseRuleError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getUnprocessedCaseRules() {
            if (this.unprocessedCaseRules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.unprocessedCaseRules;
        }

        public final void setUnprocessedCaseRules(Collection<String> unprocessedCaseRules) {
            this.unprocessedCaseRules = BatchGetCaseRuleResponseUnprocessedCaseRulesListCopier.copy(unprocessedCaseRules);
        }

        @Override
        public final Builder unprocessedCaseRules(Collection<String> unprocessedCaseRules) {
            this.unprocessedCaseRules = BatchGetCaseRuleResponseUnprocessedCaseRulesListCopier.copy(unprocessedCaseRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedCaseRules(String ... unprocessedCaseRules) {
            this.unprocessedCaseRules(Arrays.asList(unprocessedCaseRules));
            return this;
        }

        @Override
        public BatchGetCaseRuleResponse build() {
            return new BatchGetCaseRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectCasesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCaseRuleResponse> {
        public Builder caseRules(Collection<GetCaseRuleResponse> var1);

        public Builder caseRules(GetCaseRuleResponse ... var1);

        public Builder caseRules(Consumer<GetCaseRuleResponse.Builder> ... var1);

        public Builder errors(Collection<CaseRuleError> var1);

        public Builder errors(CaseRuleError ... var1);

        public Builder errors(Consumer<CaseRuleError.Builder> ... var1);

        public Builder unprocessedCaseRules(Collection<String> var1);

        public Builder unprocessedCaseRules(String ... var1);
    }
}

