/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesClient;
import software.amazon.awssdk.services.connectcases.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcases.model.GetCaseAuditEventsRequest;
import software.amazon.awssdk.services.connectcases.model.GetCaseAuditEventsResponse;

public class GetCaseAuditEventsIterable
implements SdkIterable<GetCaseAuditEventsResponse> {
    private final ConnectCasesClient client;
    private final GetCaseAuditEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCaseAuditEventsIterable(ConnectCasesClient client, GetCaseAuditEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetCaseAuditEventsResponseFetcher();
    }

    public Iterator<GetCaseAuditEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetCaseAuditEventsResponseFetcher
    implements SyncPageFetcher<GetCaseAuditEventsResponse> {
        private GetCaseAuditEventsResponseFetcher() {
        }

        public boolean hasNextPage(GetCaseAuditEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCaseAuditEventsResponse nextPage(GetCaseAuditEventsResponse previousPage) {
            if (previousPage == null) {
                return GetCaseAuditEventsIterable.this.client.getCaseAuditEvents(GetCaseAuditEventsIterable.this.firstRequest);
            }
            return GetCaseAuditEventsIterable.this.client.getCaseAuditEvents((GetCaseAuditEventsRequest)((Object)GetCaseAuditEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

