/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcases.model.CommentFilter;
import software.amazon.awssdk.services.connectcases.model.ConnectCaseFilter;
import software.amazon.awssdk.services.connectcases.model.ContactFilter;
import software.amazon.awssdk.services.connectcases.model.CustomFilter;
import software.amazon.awssdk.services.connectcases.model.FileFilter;
import software.amazon.awssdk.services.connectcases.model.SlaFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelatedItemTypeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelatedItemTypeFilter> {
    private static final SdkField<ContactFilter> CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contact").getter(RelatedItemTypeFilter.getter(RelatedItemTypeFilter::contact)).setter(RelatedItemTypeFilter.setter(Builder::contact)).constructor(ContactFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contact").build()}).build();
    private static final SdkField<CommentFilter> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("comment").getter(RelatedItemTypeFilter.getter(RelatedItemTypeFilter::comment)).setter(RelatedItemTypeFilter.setter(Builder::comment)).constructor(CommentFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<FileFilter> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("file").getter(RelatedItemTypeFilter.getter(RelatedItemTypeFilter::file)).setter(RelatedItemTypeFilter.setter(Builder::file)).constructor(FileFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()}).build();
    private static final SdkField<SlaFilter> SLA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sla").getter(RelatedItemTypeFilter.getter(RelatedItemTypeFilter::sla)).setter(RelatedItemTypeFilter.setter(Builder::sla)).constructor(SlaFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sla").build()}).build();
    private static final SdkField<ConnectCaseFilter> CONNECT_CASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectCase").getter(RelatedItemTypeFilter.getter(RelatedItemTypeFilter::connectCase)).setter(RelatedItemTypeFilter.setter(Builder::connectCase)).constructor(ConnectCaseFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectCase").build()}).build();
    private static final SdkField<CustomFilter> CUSTOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("custom").getter(RelatedItemTypeFilter.getter(RelatedItemTypeFilter::custom)).setter(RelatedItemTypeFilter.setter(Builder::custom)).constructor(CustomFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("custom").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_FIELD, COMMENT_FIELD, FILE_FIELD, SLA_FIELD, CONNECT_CASE_FIELD, CUSTOM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RelatedItemTypeFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ContactFilter contact;
    private final CommentFilter comment;
    private final FileFilter file;
    private final SlaFilter sla;
    private final ConnectCaseFilter connectCase;
    private final CustomFilter custom;
    private final Type type;

    private RelatedItemTypeFilter(BuilderImpl builder) {
        this.contact = builder.contact;
        this.comment = builder.comment;
        this.file = builder.file;
        this.sla = builder.sla;
        this.connectCase = builder.connectCase;
        this.custom = builder.custom;
        this.type = builder.type;
    }

    public final ContactFilter contact() {
        return this.contact;
    }

    public final CommentFilter comment() {
        return this.comment;
    }

    public final FileFilter file() {
        return this.file;
    }

    public final SlaFilter sla() {
        return this.sla;
    }

    public final ConnectCaseFilter connectCase() {
        return this.connectCase;
    }

    public final CustomFilter custom() {
        return this.custom;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contact());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        hashCode = 31 * hashCode + Objects.hashCode(this.sla());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectCase());
        hashCode = 31 * hashCode + Objects.hashCode(this.custom());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedItemTypeFilter)) {
            return false;
        }
        RelatedItemTypeFilter other = (RelatedItemTypeFilter)obj;
        return Objects.equals(this.contact(), other.contact()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.file(), other.file()) && Objects.equals(this.sla(), other.sla()) && Objects.equals(this.connectCase(), other.connectCase()) && Objects.equals(this.custom(), other.custom());
    }

    public final String toString() {
        return ToString.builder((String)"RelatedItemTypeFilter").add("Contact", (Object)this.contact()).add("Comment", (Object)this.comment()).add("File", (Object)this.file()).add("Sla", (Object)this.sla()).add("ConnectCase", (Object)this.connectCase()).add("Custom", (Object)this.custom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contact": {
                return Optional.ofNullable(clazz.cast(this.contact()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "file": {
                return Optional.ofNullable(clazz.cast(this.file()));
            }
            case "sla": {
                return Optional.ofNullable(clazz.cast(this.sla()));
            }
            case "connectCase": {
                return Optional.ofNullable(clazz.cast(this.connectCase()));
            }
            case "custom": {
                return Optional.ofNullable(clazz.cast(this.custom()));
            }
        }
        return Optional.empty();
    }

    public static RelatedItemTypeFilter fromContact(ContactFilter contact) {
        return (RelatedItemTypeFilter)RelatedItemTypeFilter.builder().contact(contact).build();
    }

    public static RelatedItemTypeFilter fromContact(Consumer<ContactFilter.Builder> contact) {
        ContactFilter.Builder builder = ContactFilter.builder();
        contact.accept(builder);
        return RelatedItemTypeFilter.fromContact((ContactFilter)builder.build());
    }

    public static RelatedItemTypeFilter fromComment(CommentFilter comment) {
        return (RelatedItemTypeFilter)RelatedItemTypeFilter.builder().comment(comment).build();
    }

    public static RelatedItemTypeFilter fromComment(Consumer<CommentFilter.Builder> comment) {
        CommentFilter.Builder builder = CommentFilter.builder();
        comment.accept(builder);
        return RelatedItemTypeFilter.fromComment((CommentFilter)builder.build());
    }

    public static RelatedItemTypeFilter fromFile(FileFilter file) {
        return (RelatedItemTypeFilter)RelatedItemTypeFilter.builder().file(file).build();
    }

    public static RelatedItemTypeFilter fromFile(Consumer<FileFilter.Builder> file) {
        FileFilter.Builder builder = FileFilter.builder();
        file.accept(builder);
        return RelatedItemTypeFilter.fromFile((FileFilter)builder.build());
    }

    public static RelatedItemTypeFilter fromSla(SlaFilter sla) {
        return (RelatedItemTypeFilter)RelatedItemTypeFilter.builder().sla(sla).build();
    }

    public static RelatedItemTypeFilter fromSla(Consumer<SlaFilter.Builder> sla) {
        SlaFilter.Builder builder = SlaFilter.builder();
        sla.accept(builder);
        return RelatedItemTypeFilter.fromSla((SlaFilter)builder.build());
    }

    public static RelatedItemTypeFilter fromConnectCase(ConnectCaseFilter connectCase) {
        return (RelatedItemTypeFilter)RelatedItemTypeFilter.builder().connectCase(connectCase).build();
    }

    public static RelatedItemTypeFilter fromConnectCase(Consumer<ConnectCaseFilter.Builder> connectCase) {
        ConnectCaseFilter.Builder builder = ConnectCaseFilter.builder();
        connectCase.accept(builder);
        return RelatedItemTypeFilter.fromConnectCase((ConnectCaseFilter)builder.build());
    }

    public static RelatedItemTypeFilter fromCustom(CustomFilter custom) {
        return (RelatedItemTypeFilter)RelatedItemTypeFilter.builder().custom(custom).build();
    }

    public static RelatedItemTypeFilter fromCustom(Consumer<CustomFilter.Builder> custom) {
        CustomFilter.Builder builder = CustomFilter.builder();
        custom.accept(builder);
        return RelatedItemTypeFilter.fromCustom((CustomFilter)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contact", CONTACT_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("file", FILE_FIELD);
        map.put("sla", SLA_FIELD);
        map.put("connectCase", CONNECT_CASE_FIELD);
        map.put("custom", CUSTOM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelatedItemTypeFilter, T> g) {
        return obj -> g.apply((RelatedItemTypeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CONTACT,
        COMMENT,
        FILE,
        SLA,
        CONNECT_CASE,
        CUSTOM,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ContactFilter contact;
        private CommentFilter comment;
        private FileFilter file;
        private SlaFilter sla;
        private ConnectCaseFilter connectCase;
        private CustomFilter custom;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedItemTypeFilter model) {
            this.contact(model.contact);
            this.comment(model.comment);
            this.file(model.file);
            this.sla(model.sla);
            this.connectCase(model.connectCase);
            this.custom(model.custom);
        }

        public final ContactFilter.Builder getContact() {
            return this.contact != null ? this.contact.toBuilder() : null;
        }

        public final void setContact(ContactFilter.BuilderImpl contact) {
            ContactFilter oldValue = this.contact;
            this.contact = contact != null ? contact.build() : null;
            this.handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
        }

        @Override
        public final Builder contact(ContactFilter contact) {
            ContactFilter oldValue = this.contact;
            this.contact = contact;
            this.handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
            return this;
        }

        public final CommentFilter.Builder getComment() {
            return this.comment != null ? this.comment.toBuilder() : null;
        }

        public final void setComment(CommentFilter.BuilderImpl comment) {
            CommentFilter oldValue = this.comment;
            this.comment = comment != null ? comment.build() : null;
            this.handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
        }

        @Override
        public final Builder comment(CommentFilter comment) {
            CommentFilter oldValue = this.comment;
            this.comment = comment;
            this.handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
            return this;
        }

        public final FileFilter.Builder getFile() {
            return this.file != null ? this.file.toBuilder() : null;
        }

        public final void setFile(FileFilter.BuilderImpl file) {
            FileFilter oldValue = this.file;
            this.file = file != null ? file.build() : null;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        public final Builder file(FileFilter file) {
            FileFilter oldValue = this.file;
            this.file = file;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        public final SlaFilter.Builder getSla() {
            return this.sla != null ? this.sla.toBuilder() : null;
        }

        public final void setSla(SlaFilter.BuilderImpl sla) {
            SlaFilter oldValue = this.sla;
            this.sla = sla != null ? sla.build() : null;
            this.handleUnionValueChange(Type.SLA, oldValue, this.sla);
        }

        @Override
        public final Builder sla(SlaFilter sla) {
            SlaFilter oldValue = this.sla;
            this.sla = sla;
            this.handleUnionValueChange(Type.SLA, oldValue, this.sla);
            return this;
        }

        public final ConnectCaseFilter.Builder getConnectCase() {
            return this.connectCase != null ? this.connectCase.toBuilder() : null;
        }

        public final void setConnectCase(ConnectCaseFilter.BuilderImpl connectCase) {
            ConnectCaseFilter oldValue = this.connectCase;
            this.connectCase = connectCase != null ? connectCase.build() : null;
            this.handleUnionValueChange(Type.CONNECT_CASE, oldValue, this.connectCase);
        }

        @Override
        public final Builder connectCase(ConnectCaseFilter connectCase) {
            ConnectCaseFilter oldValue = this.connectCase;
            this.connectCase = connectCase;
            this.handleUnionValueChange(Type.CONNECT_CASE, oldValue, this.connectCase);
            return this;
        }

        public final CustomFilter.Builder getCustom() {
            return this.custom != null ? this.custom.toBuilder() : null;
        }

        public final void setCustom(CustomFilter.BuilderImpl custom) {
            CustomFilter oldValue = this.custom;
            this.custom = custom != null ? custom.build() : null;
            this.handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
        }

        @Override
        public final Builder custom(CustomFilter custom) {
            CustomFilter oldValue = this.custom;
            this.custom = custom;
            this.handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
            return this;
        }

        public RelatedItemTypeFilter build() {
            return new RelatedItemTypeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelatedItemTypeFilter> {
        public Builder contact(ContactFilter var1);

        default public Builder contact(Consumer<ContactFilter.Builder> contact) {
            return this.contact((ContactFilter)((ContactFilter.Builder)ContactFilter.builder().applyMutation(contact)).build());
        }

        public Builder comment(CommentFilter var1);

        default public Builder comment(Consumer<CommentFilter.Builder> comment) {
            return this.comment((CommentFilter)((CommentFilter.Builder)CommentFilter.builder().applyMutation(comment)).build());
        }

        public Builder file(FileFilter var1);

        default public Builder file(Consumer<FileFilter.Builder> file) {
            return this.file((FileFilter)((FileFilter.Builder)FileFilter.builder().applyMutation(file)).build());
        }

        public Builder sla(SlaFilter var1);

        default public Builder sla(Consumer<SlaFilter.Builder> sla) {
            return this.sla((SlaFilter)((SlaFilter.Builder)SlaFilter.builder().applyMutation(sla)).build());
        }

        public Builder connectCase(ConnectCaseFilter var1);

        default public Builder connectCase(Consumer<ConnectCaseFilter.Builder> connectCase) {
            return this.connectCase((ConnectCaseFilter)((ConnectCaseFilter.Builder)ConnectCaseFilter.builder().applyMutation(connectCase)).build());
        }

        public Builder custom(CustomFilter var1);

        default public Builder custom(Consumer<CustomFilter.Builder> custom) {
            return this.custom((CustomFilter)((CustomFilter.Builder)CustomFilter.builder().applyMutation(custom)).build());
        }
    }
}

