/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SlaStatus {
    ACTIVE("Active"),
    OVERDUE("Overdue"),
    MET("Met"),
    NOT_MET("NotMet"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SlaStatus> VALUE_MAP;
    private final String value;

    private SlaStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SlaStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SlaStatus> knownValues() {
        EnumSet<SlaStatus> knownValues = EnumSet.allOf(SlaStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SlaStatus.class, SlaStatus::toString);
    }
}

