/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.CaseFilter;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesRequest;
import software.amazon.awssdk.services.connectcases.model.FieldIdentifier;
import software.amazon.awssdk.services.connectcases.model.SearchCasesRequestFieldsListCopier;
import software.amazon.awssdk.services.connectcases.model.SearchCasesRequestSortsListCopier;
import software.amazon.awssdk.services.connectcases.model.Sort;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchCasesRequest
extends ConnectCasesRequest
implements ToCopyableBuilder<Builder, SearchCasesRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(SearchCasesRequest.getter(SearchCasesRequest::domainId)).setter(SearchCasesRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainId").build()}).build();
    private static final SdkField<List<FieldIdentifier>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fields").getter(SearchCasesRequest.getter(SearchCasesRequest::fields)).setter(SearchCasesRequest.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CaseFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filter").getter(SearchCasesRequest.getter(SearchCasesRequest::filter)).setter(SearchCasesRequest.setter(Builder::filter)).constructor(CaseFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(SearchCasesRequest.getter(SearchCasesRequest::maxResults)).setter(SearchCasesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchCasesRequest.getter(SearchCasesRequest::nextToken)).setter(SearchCasesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> SEARCH_TERM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("searchTerm").getter(SearchCasesRequest.getter(SearchCasesRequest::searchTerm)).setter(SearchCasesRequest.setter(Builder::searchTerm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchTerm").build()}).build();
    private static final SdkField<List<Sort>> SORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sorts").getter(SearchCasesRequest.getter(SearchCasesRequest::sorts)).setter(SearchCasesRequest.setter(Builder::sorts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sorts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Sort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, FIELDS_FIELD, FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SEARCH_TERM_FIELD, SORTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchCasesRequest.memberNameToFieldInitializer();
    private final String domainId;
    private final List<FieldIdentifier> fields;
    private final CaseFilter filter;
    private final Integer maxResults;
    private final String nextToken;
    private final String searchTerm;
    private final List<Sort> sorts;

    private SearchCasesRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.fields = builder.fields;
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.searchTerm = builder.searchTerm;
        this.sorts = builder.sorts;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<FieldIdentifier> fields() {
        return this.fields;
    }

    public final CaseFilter filter() {
        return this.filter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String searchTerm() {
        return this.searchTerm;
    }

    public final boolean hasSorts() {
        return this.sorts != null && !(this.sorts instanceof SdkAutoConstructList);
    }

    public final List<Sort> sorts() {
        return this.sorts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchTerm());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSorts() ? this.sorts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchCasesRequest)) {
            return false;
        }
        SearchCasesRequest other = (SearchCasesRequest)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.searchTerm(), other.searchTerm()) && this.hasSorts() == other.hasSorts() && Objects.equals(this.sorts(), other.sorts());
    }

    public final String toString() {
        return ToString.builder((String)"SearchCasesRequest").add("DomainId", (Object)this.domainId()).add("Fields", this.hasFields() ? this.fields() : null).add("Filter", (Object)this.filter()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SearchTerm", (Object)this.searchTerm()).add("Sorts", this.hasSorts() ? this.sorts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "searchTerm": {
                return Optional.ofNullable(clazz.cast(this.searchTerm()));
            }
            case "sorts": {
                return Optional.ofNullable(clazz.cast(this.sorts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("fields", FIELDS_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("searchTerm", SEARCH_TERM_FIELD);
        map.put("sorts", SORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchCasesRequest, T> g) {
        return obj -> g.apply((SearchCasesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesRequest.BuilderImpl
    implements Builder {
        private String domainId;
        private List<FieldIdentifier> fields = DefaultSdkAutoConstructList.getInstance();
        private CaseFilter filter;
        private Integer maxResults;
        private String nextToken;
        private String searchTerm;
        private List<Sort> sorts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchCasesRequest model) {
            super(model);
            this.domainId(model.domainId);
            this.fields(model.fields);
            this.filter(model.filter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.searchTerm(model.searchTerm);
            this.sorts(model.sorts);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final List<FieldIdentifier.Builder> getFields() {
            List<FieldIdentifier.Builder> result = SearchCasesRequestFieldsListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<FieldIdentifier.BuilderImpl> fields) {
            this.fields = SearchCasesRequestFieldsListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<FieldIdentifier> fields) {
            this.fields = SearchCasesRequestFieldsListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(FieldIdentifier ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<FieldIdentifier.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (FieldIdentifier)((FieldIdentifier.Builder)FieldIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CaseFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(CaseFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(CaseFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSearchTerm() {
            return this.searchTerm;
        }

        public final void setSearchTerm(String searchTerm) {
            this.searchTerm = searchTerm;
        }

        @Override
        public final Builder searchTerm(String searchTerm) {
            this.searchTerm = searchTerm;
            return this;
        }

        public final List<Sort.Builder> getSorts() {
            List<Sort.Builder> result = SearchCasesRequestSortsListCopier.copyToBuilder(this.sorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSorts(Collection<Sort.BuilderImpl> sorts) {
            this.sorts = SearchCasesRequestSortsListCopier.copyFromBuilder(sorts);
        }

        @Override
        public final Builder sorts(Collection<Sort> sorts) {
            this.sorts = SearchCasesRequestSortsListCopier.copy(sorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sorts(Sort ... sorts) {
            this.sorts(Arrays.asList(sorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sorts(Consumer<Sort.Builder> ... sorts) {
            this.sorts(Stream.of(sorts).map(c -> (Sort)((Sort.Builder)Sort.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchCasesRequest build() {
            return new SearchCasesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectCasesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchCasesRequest> {
        public Builder domainId(String var1);

        public Builder fields(Collection<FieldIdentifier> var1);

        public Builder fields(FieldIdentifier ... var1);

        public Builder fields(Consumer<FieldIdentifier.Builder> ... var1);

        public Builder filter(CaseFilter var1);

        default public Builder filter(Consumer<CaseFilter.Builder> filter) {
            return this.filter((CaseFilter)((CaseFilter.Builder)CaseFilter.builder().applyMutation(filter)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder searchTerm(String var1);

        public Builder sorts(Collection<Sort> var1);

        public Builder sorts(Sort ... var1);

        public Builder sorts(Consumer<Sort.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

