/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesRequest;
import software.amazon.awssdk.services.connectcases.model.RelatedItemInputContent;
import software.amazon.awssdk.services.connectcases.model.RelatedItemType;
import software.amazon.awssdk.services.connectcases.model.UserUnion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRelatedItemRequest
extends ConnectCasesRequest
implements ToCopyableBuilder<Builder, CreateRelatedItemRequest> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caseId").getter(CreateRelatedItemRequest.getter(CreateRelatedItemRequest::caseId)).setter(CreateRelatedItemRequest.setter(Builder::caseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("caseId").build()}).build();
    private static final SdkField<RelatedItemInputContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(CreateRelatedItemRequest.getter(CreateRelatedItemRequest::content)).setter(CreateRelatedItemRequest.setter(Builder::content)).constructor(RelatedItemInputContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(CreateRelatedItemRequest.getter(CreateRelatedItemRequest::domainId)).setter(CreateRelatedItemRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainId").build()}).build();
    private static final SdkField<UserUnion> PERFORMED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("performedBy").getter(CreateRelatedItemRequest.getter(CreateRelatedItemRequest::performedBy)).setter(CreateRelatedItemRequest.setter(Builder::performedBy)).constructor(UserUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performedBy").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateRelatedItemRequest.getter(CreateRelatedItemRequest::typeAsString)).setter(CreateRelatedItemRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD, CONTENT_FIELD, DOMAIN_ID_FIELD, PERFORMED_BY_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRelatedItemRequest.memberNameToFieldInitializer();
    private final String caseId;
    private final RelatedItemInputContent content;
    private final String domainId;
    private final UserUnion performedBy;
    private final String type;

    private CreateRelatedItemRequest(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.content = builder.content;
        this.domainId = builder.domainId;
        this.performedBy = builder.performedBy;
        this.type = builder.type;
    }

    public final String caseId() {
        return this.caseId;
    }

    public final RelatedItemInputContent content() {
        return this.content;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final UserUnion performedBy() {
        return this.performedBy;
    }

    public final RelatedItemType type() {
        return RelatedItemType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.caseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.performedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRelatedItemRequest)) {
            return false;
        }
        CreateRelatedItemRequest other = (CreateRelatedItemRequest)((Object)obj);
        return Objects.equals(this.caseId(), other.caseId()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.performedBy(), other.performedBy()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRelatedItemRequest").add("CaseId", (Object)this.caseId()).add("Content", (Object)this.content()).add("DomainId", (Object)this.domainId()).add("PerformedBy", (Object)this.performedBy()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseId": {
                return Optional.ofNullable(clazz.cast(this.caseId()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "performedBy": {
                return Optional.ofNullable(clazz.cast(this.performedBy()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("caseId", CASE_ID_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("performedBy", PERFORMED_BY_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRelatedItemRequest, T> g) {
        return obj -> g.apply((CreateRelatedItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesRequest.BuilderImpl
    implements Builder {
        private String caseId;
        private RelatedItemInputContent content;
        private String domainId;
        private UserUnion performedBy;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRelatedItemRequest model) {
            super(model);
            this.caseId(model.caseId);
            this.content(model.content);
            this.domainId(model.domainId);
            this.performedBy(model.performedBy);
            this.type(model.type);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final RelatedItemInputContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(RelatedItemInputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(RelatedItemInputContent content) {
            this.content = content;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final UserUnion.Builder getPerformedBy() {
            return this.performedBy != null ? this.performedBy.toBuilder() : null;
        }

        public final void setPerformedBy(UserUnion.BuilderImpl performedBy) {
            this.performedBy = performedBy != null ? performedBy.build() : null;
        }

        @Override
        public final Builder performedBy(UserUnion performedBy) {
            this.performedBy = performedBy;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RelatedItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRelatedItemRequest build() {
            return new CreateRelatedItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectCasesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRelatedItemRequest> {
        public Builder caseId(String var1);

        public Builder content(RelatedItemInputContent var1);

        default public Builder content(Consumer<RelatedItemInputContent.Builder> content) {
            return this.content((RelatedItemInputContent)((RelatedItemInputContent.Builder)RelatedItemInputContent.builder().applyMutation(content)).build());
        }

        public Builder domainId(String var1);

        public Builder performedBy(UserUnion var1);

        default public Builder performedBy(Consumer<UserUnion.Builder> performedBy) {
            return this.performedBy((UserUnion)((UserUnion.Builder)UserUnion.builder().applyMutation(performedBy)).build());
        }

        public Builder type(String var1);

        public Builder type(RelatedItemType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

