/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesClient;
import software.amazon.awssdk.services.connectcases.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcases.model.GetCaseRequest;
import software.amazon.awssdk.services.connectcases.model.GetCaseResponse;

public class GetCaseIterable
implements SdkIterable<GetCaseResponse> {
    private final ConnectCasesClient client;
    private final GetCaseRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCaseIterable(ConnectCasesClient client, GetCaseRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetCaseResponseFetcher();
    }

    public Iterator<GetCaseResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetCaseResponseFetcher
    implements SyncPageFetcher<GetCaseResponse> {
        private GetCaseResponseFetcher() {
        }

        public boolean hasNextPage(GetCaseResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCaseResponse nextPage(GetCaseResponse previousPage) {
            if (previousPage == null) {
                return GetCaseIterable.this.client.getCase(GetCaseIterable.this.firstRequest);
            }
            return GetCaseIterable.this.client.getCase((GetCaseRequest)((Object)GetCaseIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

