/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcases.model.CaseRuleDetails;
import software.amazon.awssdk.services.connectcases.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCaseRuleResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GetCaseRuleResponse> {
    private static final SdkField<String> CASE_RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caseRuleArn").getter(GetCaseRuleResponse.getter(GetCaseRuleResponse::caseRuleArn)).setter(GetCaseRuleResponse.setter(Builder::caseRuleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRuleArn").build()}).build();
    private static final SdkField<String> CASE_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caseRuleId").getter(GetCaseRuleResponse.getter(GetCaseRuleResponse::caseRuleId)).setter(GetCaseRuleResponse.setter(Builder::caseRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRuleId").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(GetCaseRuleResponse.getter(GetCaseRuleResponse::createdTime)).setter(GetCaseRuleResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deleted").getter(GetCaseRuleResponse.getter(GetCaseRuleResponse::deleted)).setter(GetCaseRuleResponse.setter(Builder::deleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleted").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetCaseRuleResponse.getter(GetCaseRuleResponse::description)).setter(GetCaseRuleResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(GetCaseRuleResponse.getter(GetCaseRuleResponse::lastModifiedTime)).setter(GetCaseRuleResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetCaseRuleResponse.getter(GetCaseRuleResponse::name)).setter(GetCaseRuleResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<CaseRuleDetails> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rule").getter(GetCaseRuleResponse.getter(GetCaseRuleResponse::rule)).setter(GetCaseRuleResponse.setter(Builder::rule)).constructor(CaseRuleDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rule").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetCaseRuleResponse.getter(GetCaseRuleResponse::tags)).setter(GetCaseRuleResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_RULE_ARN_FIELD, CASE_RULE_ID_FIELD, CREATED_TIME_FIELD, DELETED_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_TIME_FIELD, NAME_FIELD, RULE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCaseRuleResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String caseRuleArn;
    private final String caseRuleId;
    private final Instant createdTime;
    private final Boolean deleted;
    private final String description;
    private final Instant lastModifiedTime;
    private final String name;
    private final CaseRuleDetails rule;
    private final Map<String, String> tags;

    private GetCaseRuleResponse(BuilderImpl builder) {
        this.caseRuleArn = builder.caseRuleArn;
        this.caseRuleId = builder.caseRuleId;
        this.createdTime = builder.createdTime;
        this.deleted = builder.deleted;
        this.description = builder.description;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.name = builder.name;
        this.rule = builder.rule;
        this.tags = builder.tags;
    }

    public final String caseRuleArn() {
        return this.caseRuleArn;
    }

    public final String caseRuleId() {
        return this.caseRuleId;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Boolean deleted() {
        return this.deleted;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String name() {
        return this.name;
    }

    public final CaseRuleDetails rule() {
        return this.rule;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.caseRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.caseRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCaseRuleResponse)) {
            return false;
        }
        GetCaseRuleResponse other = (GetCaseRuleResponse)obj;
        return Objects.equals(this.caseRuleArn(), other.caseRuleArn()) && Objects.equals(this.caseRuleId(), other.caseRuleId()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.deleted(), other.deleted()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.rule(), other.rule()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetCaseRuleResponse").add("CaseRuleArn", (Object)this.caseRuleArn()).add("CaseRuleId", (Object)this.caseRuleId()).add("CreatedTime", (Object)this.createdTime()).add("Deleted", (Object)this.deleted()).add("Description", (Object)this.description()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Name", (Object)this.name()).add("Rule", (Object)this.rule()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseRuleArn": {
                return Optional.ofNullable(clazz.cast(this.caseRuleArn()));
            }
            case "caseRuleId": {
                return Optional.ofNullable(clazz.cast(this.caseRuleId()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "deleted": {
                return Optional.ofNullable(clazz.cast(this.deleted()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("caseRuleArn", CASE_RULE_ARN_FIELD);
        map.put("caseRuleId", CASE_RULE_ID_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("deleted", DELETED_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("rule", RULE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCaseRuleResponse, T> g) {
        return obj -> g.apply((GetCaseRuleResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String caseRuleArn;
        private String caseRuleId;
        private Instant createdTime;
        private Boolean deleted;
        private String description;
        private Instant lastModifiedTime;
        private String name;
        private CaseRuleDetails rule;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCaseRuleResponse model) {
            this.caseRuleArn(model.caseRuleArn);
            this.caseRuleId(model.caseRuleId);
            this.createdTime(model.createdTime);
            this.deleted(model.deleted);
            this.description(model.description);
            this.lastModifiedTime(model.lastModifiedTime);
            this.name(model.name);
            this.rule(model.rule);
            this.tags(model.tags);
        }

        public final String getCaseRuleArn() {
            return this.caseRuleArn;
        }

        public final void setCaseRuleArn(String caseRuleArn) {
            this.caseRuleArn = caseRuleArn;
        }

        @Override
        public final Builder caseRuleArn(String caseRuleArn) {
            this.caseRuleArn = caseRuleArn;
            return this;
        }

        public final String getCaseRuleId() {
            return this.caseRuleId;
        }

        public final void setCaseRuleId(String caseRuleId) {
            this.caseRuleId = caseRuleId;
        }

        @Override
        public final Builder caseRuleId(String caseRuleId) {
            this.caseRuleId = caseRuleId;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Boolean getDeleted() {
            return this.deleted;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CaseRuleDetails.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        public final void setRule(CaseRuleDetails.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(CaseRuleDetails rule) {
            this.rule = rule;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public GetCaseRuleResponse build() {
            return new GetCaseRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GetCaseRuleResponse> {
        public Builder caseRuleArn(String var1);

        public Builder caseRuleId(String var1);

        public Builder createdTime(Instant var1);

        public Builder deleted(Boolean var1);

        public Builder description(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder name(String var1);

        public Builder rule(CaseRuleDetails var1);

        default public Builder rule(Consumer<CaseRuleDetails.Builder> rule) {
            return this.rule((CaseRuleDetails)((CaseRuleDetails.Builder)CaseRuleDetails.builder().applyMutation(rule)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

