/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcampaignsv2.model.AgentlessConfig;
import software.amazon.awssdk.services.connectcampaignsv2.model.PredictiveConfig;
import software.amazon.awssdk.services.connectcampaignsv2.model.ProgressiveConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TelephonyOutboundMode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TelephonyOutboundMode> {
    private static final SdkField<ProgressiveConfig> PROGRESSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("progressive").getter(TelephonyOutboundMode.getter(TelephonyOutboundMode::progressive)).setter(TelephonyOutboundMode.setter(Builder::progressive)).constructor(ProgressiveConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressive").build()}).build();
    private static final SdkField<PredictiveConfig> PREDICTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("predictive").getter(TelephonyOutboundMode.getter(TelephonyOutboundMode::predictive)).setter(TelephonyOutboundMode.setter(Builder::predictive)).constructor(PredictiveConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictive").build()}).build();
    private static final SdkField<AgentlessConfig> AGENTLESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("agentless").getter(TelephonyOutboundMode.getter(TelephonyOutboundMode::agentless)).setter(TelephonyOutboundMode.setter(Builder::agentless)).constructor(AgentlessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentless").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESSIVE_FIELD, PREDICTIVE_FIELD, AGENTLESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TelephonyOutboundMode.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ProgressiveConfig progressive;
    private final PredictiveConfig predictive;
    private final AgentlessConfig agentless;
    private final Type type;

    private TelephonyOutboundMode(BuilderImpl builder) {
        this.progressive = builder.progressive;
        this.predictive = builder.predictive;
        this.agentless = builder.agentless;
        this.type = builder.type;
    }

    public final ProgressiveConfig progressive() {
        return this.progressive;
    }

    public final PredictiveConfig predictive() {
        return this.predictive;
    }

    public final AgentlessConfig agentless() {
        return this.agentless;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.progressive());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictive());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentless());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelephonyOutboundMode)) {
            return false;
        }
        TelephonyOutboundMode other = (TelephonyOutboundMode)obj;
        return Objects.equals(this.progressive(), other.progressive()) && Objects.equals(this.predictive(), other.predictive()) && Objects.equals(this.agentless(), other.agentless());
    }

    public final String toString() {
        return ToString.builder((String)"TelephonyOutboundMode").add("Progressive", (Object)this.progressive()).add("Predictive", (Object)this.predictive()).add("Agentless", (Object)this.agentless()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "progressive": {
                return Optional.ofNullable(clazz.cast(this.progressive()));
            }
            case "predictive": {
                return Optional.ofNullable(clazz.cast(this.predictive()));
            }
            case "agentless": {
                return Optional.ofNullable(clazz.cast(this.agentless()));
            }
        }
        return Optional.empty();
    }

    public static TelephonyOutboundMode fromProgressive(ProgressiveConfig progressive) {
        return (TelephonyOutboundMode)TelephonyOutboundMode.builder().progressive(progressive).build();
    }

    public static TelephonyOutboundMode fromProgressive(Consumer<ProgressiveConfig.Builder> progressive) {
        ProgressiveConfig.Builder builder = ProgressiveConfig.builder();
        progressive.accept(builder);
        return TelephonyOutboundMode.fromProgressive((ProgressiveConfig)builder.build());
    }

    public static TelephonyOutboundMode fromPredictive(PredictiveConfig predictive) {
        return (TelephonyOutboundMode)TelephonyOutboundMode.builder().predictive(predictive).build();
    }

    public static TelephonyOutboundMode fromPredictive(Consumer<PredictiveConfig.Builder> predictive) {
        PredictiveConfig.Builder builder = PredictiveConfig.builder();
        predictive.accept(builder);
        return TelephonyOutboundMode.fromPredictive((PredictiveConfig)builder.build());
    }

    public static TelephonyOutboundMode fromAgentless(AgentlessConfig agentless) {
        return (TelephonyOutboundMode)TelephonyOutboundMode.builder().agentless(agentless).build();
    }

    public static TelephonyOutboundMode fromAgentless(Consumer<AgentlessConfig.Builder> agentless) {
        AgentlessConfig.Builder builder = AgentlessConfig.builder();
        agentless.accept(builder);
        return TelephonyOutboundMode.fromAgentless((AgentlessConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("progressive", PROGRESSIVE_FIELD);
        map.put("predictive", PREDICTIVE_FIELD);
        map.put("agentless", AGENTLESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelephonyOutboundMode, T> g) {
        return obj -> g.apply((TelephonyOutboundMode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PROGRESSIVE,
        PREDICTIVE,
        AGENTLESS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ProgressiveConfig progressive;
        private PredictiveConfig predictive;
        private AgentlessConfig agentless;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TelephonyOutboundMode model) {
            this.progressive(model.progressive);
            this.predictive(model.predictive);
            this.agentless(model.agentless);
        }

        public final ProgressiveConfig.Builder getProgressive() {
            return this.progressive != null ? this.progressive.toBuilder() : null;
        }

        public final void setProgressive(ProgressiveConfig.BuilderImpl progressive) {
            ProgressiveConfig oldValue = this.progressive;
            this.progressive = progressive != null ? progressive.build() : null;
            this.handleUnionValueChange(Type.PROGRESSIVE, oldValue, this.progressive);
        }

        @Override
        public final Builder progressive(ProgressiveConfig progressive) {
            ProgressiveConfig oldValue = this.progressive;
            this.progressive = progressive;
            this.handleUnionValueChange(Type.PROGRESSIVE, oldValue, this.progressive);
            return this;
        }

        public final PredictiveConfig.Builder getPredictive() {
            return this.predictive != null ? this.predictive.toBuilder() : null;
        }

        public final void setPredictive(PredictiveConfig.BuilderImpl predictive) {
            PredictiveConfig oldValue = this.predictive;
            this.predictive = predictive != null ? predictive.build() : null;
            this.handleUnionValueChange(Type.PREDICTIVE, oldValue, this.predictive);
        }

        @Override
        public final Builder predictive(PredictiveConfig predictive) {
            PredictiveConfig oldValue = this.predictive;
            this.predictive = predictive;
            this.handleUnionValueChange(Type.PREDICTIVE, oldValue, this.predictive);
            return this;
        }

        public final AgentlessConfig.Builder getAgentless() {
            return this.agentless != null ? this.agentless.toBuilder() : null;
        }

        public final void setAgentless(AgentlessConfig.BuilderImpl agentless) {
            AgentlessConfig oldValue = this.agentless;
            this.agentless = agentless != null ? agentless.build() : null;
            this.handleUnionValueChange(Type.AGENTLESS, oldValue, this.agentless);
        }

        @Override
        public final Builder agentless(AgentlessConfig agentless) {
            AgentlessConfig oldValue = this.agentless;
            this.agentless = agentless;
            this.handleUnionValueChange(Type.AGENTLESS, oldValue, this.agentless);
            return this;
        }

        public TelephonyOutboundMode build() {
            return new TelephonyOutboundMode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TelephonyOutboundMode> {
        public Builder progressive(ProgressiveConfig var1);

        default public Builder progressive(Consumer<ProgressiveConfig.Builder> progressive) {
            return this.progressive((ProgressiveConfig)((ProgressiveConfig.Builder)ProgressiveConfig.builder().applyMutation(progressive)).build());
        }

        public Builder predictive(PredictiveConfig var1);

        default public Builder predictive(Consumer<PredictiveConfig.Builder> predictive) {
            return this.predictive((PredictiveConfig)((PredictiveConfig.Builder)PredictiveConfig.builder().applyMutation(predictive)).build());
        }

        public Builder agentless(AgentlessConfig var1);

        default public Builder agentless(Consumer<AgentlessConfig.Builder> agentless) {
            return this.agentless((AgentlessConfig)((AgentlessConfig.Builder)AgentlessConfig.builder().applyMutation(agentless)).build());
        }
    }
}

