/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaigns.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcampaigns.model.DialerConfig;
import software.amazon.awssdk.services.connectcampaigns.model.OutboundCallConfig;
import software.amazon.awssdk.services.connectcampaigns.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Campaign
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Campaign> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Campaign.getter(Campaign::id)).setter(Campaign.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Campaign.getter(Campaign::arn)).setter(Campaign.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Campaign.getter(Campaign::name)).setter(Campaign.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> CONNECT_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectInstanceId").getter(Campaign.getter(Campaign::connectInstanceId)).setter(Campaign.setter(Builder::connectInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectInstanceId").build()}).build();
    private static final SdkField<DialerConfig> DIALER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dialerConfig").getter(Campaign.getter(Campaign::dialerConfig)).setter(Campaign.setter(Builder::dialerConfig)).constructor(DialerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialerConfig").build()}).build();
    private static final SdkField<OutboundCallConfig> OUTBOUND_CALL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outboundCallConfig").getter(Campaign.getter(Campaign::outboundCallConfig)).setter(Campaign.setter(Builder::outboundCallConfig)).constructor(OutboundCallConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outboundCallConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Campaign.getter(Campaign::tags)).setter(Campaign.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, CONNECT_INSTANCE_ID_FIELD, DIALER_CONFIG_FIELD, OUTBOUND_CALL_CONFIG_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Campaign.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final String connectInstanceId;
    private final DialerConfig dialerConfig;
    private final OutboundCallConfig outboundCallConfig;
    private final Map<String, String> tags;

    private Campaign(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.connectInstanceId = builder.connectInstanceId;
        this.dialerConfig = builder.dialerConfig;
        this.outboundCallConfig = builder.outboundCallConfig;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String connectInstanceId() {
        return this.connectInstanceId;
    }

    public final DialerConfig dialerConfig() {
        return this.dialerConfig;
    }

    public final OutboundCallConfig outboundCallConfig() {
        return this.outboundCallConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outboundCallConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Campaign)) {
            return false;
        }
        Campaign other = (Campaign)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.connectInstanceId(), other.connectInstanceId()) && Objects.equals(this.dialerConfig(), other.dialerConfig()) && Objects.equals(this.outboundCallConfig(), other.outboundCallConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Campaign").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("ConnectInstanceId", (Object)this.connectInstanceId()).add("DialerConfig", (Object)this.dialerConfig()).add("OutboundCallConfig", (Object)this.outboundCallConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "connectInstanceId": {
                return Optional.ofNullable(clazz.cast(this.connectInstanceId()));
            }
            case "dialerConfig": {
                return Optional.ofNullable(clazz.cast(this.dialerConfig()));
            }
            case "outboundCallConfig": {
                return Optional.ofNullable(clazz.cast(this.outboundCallConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("connectInstanceId", CONNECT_INSTANCE_ID_FIELD);
        map.put("dialerConfig", DIALER_CONFIG_FIELD);
        map.put("outboundCallConfig", OUTBOUND_CALL_CONFIG_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Campaign, T> g) {
        return obj -> g.apply((Campaign)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String connectInstanceId;
        private DialerConfig dialerConfig;
        private OutboundCallConfig outboundCallConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Campaign model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.connectInstanceId(model.connectInstanceId);
            this.dialerConfig(model.dialerConfig);
            this.outboundCallConfig(model.outboundCallConfig);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getConnectInstanceId() {
            return this.connectInstanceId;
        }

        public final void setConnectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
        }

        @Override
        public final Builder connectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
            return this;
        }

        public final DialerConfig.Builder getDialerConfig() {
            return this.dialerConfig != null ? this.dialerConfig.toBuilder() : null;
        }

        public final void setDialerConfig(DialerConfig.BuilderImpl dialerConfig) {
            this.dialerConfig = dialerConfig != null ? dialerConfig.build() : null;
        }

        @Override
        public final Builder dialerConfig(DialerConfig dialerConfig) {
            this.dialerConfig = dialerConfig;
            return this;
        }

        public final OutboundCallConfig.Builder getOutboundCallConfig() {
            return this.outboundCallConfig != null ? this.outboundCallConfig.toBuilder() : null;
        }

        public final void setOutboundCallConfig(OutboundCallConfig.BuilderImpl outboundCallConfig) {
            this.outboundCallConfig = outboundCallConfig != null ? outboundCallConfig.build() : null;
        }

        @Override
        public final Builder outboundCallConfig(OutboundCallConfig outboundCallConfig) {
            this.outboundCallConfig = outboundCallConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public Campaign build() {
            return new Campaign(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Campaign> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder connectInstanceId(String var1);

        public Builder dialerConfig(DialerConfig var1);

        default public Builder dialerConfig(Consumer<DialerConfig.Builder> dialerConfig) {
            return this.dialerConfig((DialerConfig)((DialerConfig.Builder)DialerConfig.builder().applyMutation(dialerConfig)).build());
        }

        public Builder outboundCallConfig(OutboundCallConfig var1);

        default public Builder outboundCallConfig(Consumer<OutboundCallConfig.Builder> outboundCallConfig) {
            return this.outboundCallConfig((OutboundCallConfig)((OutboundCallConfig.Builder)OutboundCallConfig.builder().applyMutation(outboundCallConfig)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

