/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.SearchWorkspaceAssociationsRequest;
import software.amazon.awssdk.services.connect.model.SearchWorkspaceAssociationsResponse;
import software.amazon.awssdk.services.connect.model.WorkspaceAssociationSearchSummary;

public class SearchWorkspaceAssociationsPublisher
implements SdkPublisher<SearchWorkspaceAssociationsResponse> {
    private final ConnectAsyncClient client;
    private final SearchWorkspaceAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchWorkspaceAssociationsPublisher(ConnectAsyncClient client, SearchWorkspaceAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchWorkspaceAssociationsPublisher(ConnectAsyncClient client, SearchWorkspaceAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchWorkspaceAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchWorkspaceAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkspaceAssociationSearchSummary> workspaceAssociations() {
        Function<SearchWorkspaceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workspaceAssociations() != null) {
                return response.workspaceAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchWorkspaceAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchWorkspaceAssociationsResponseFetcher
    implements AsyncPageFetcher<SearchWorkspaceAssociationsResponse> {
        private SearchWorkspaceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(SearchWorkspaceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchWorkspaceAssociationsResponse> nextPage(SearchWorkspaceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return SearchWorkspaceAssociationsPublisher.this.client.searchWorkspaceAssociations(SearchWorkspaceAssociationsPublisher.this.firstRequest);
            }
            return SearchWorkspaceAssociationsPublisher.this.client.searchWorkspaceAssociations((SearchWorkspaceAssociationsRequest)((Object)SearchWorkspaceAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

