/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.SearchViewsRequest;
import software.amazon.awssdk.services.connect.model.SearchViewsResponse;
import software.amazon.awssdk.services.connect.model.View;

public class SearchViewsIterable
implements SdkIterable<SearchViewsResponse> {
    private final ConnectClient client;
    private final SearchViewsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchViewsIterable(ConnectClient client, SearchViewsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchViewsResponseFetcher();
    }

    public Iterator<SearchViewsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<View> views() {
        Function<SearchViewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.views() != null) {
                return response.views().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchViewsResponseFetcher
    implements SyncPageFetcher<SearchViewsResponse> {
        private SearchViewsResponseFetcher() {
        }

        public boolean hasNextPage(SearchViewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchViewsResponse nextPage(SearchViewsResponse previousPage) {
            if (previousPage == null) {
                return SearchViewsIterable.this.client.searchViews(SearchViewsIterable.this.firstRequest);
            }
            return SearchViewsIterable.this.client.searchViews((SearchViewsRequest)((Object)SearchViewsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

