/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.DataTable;
import software.amazon.awssdk.services.connect.model.SearchDataTablesRequest;
import software.amazon.awssdk.services.connect.model.SearchDataTablesResponse;

public class SearchDataTablesIterable
implements SdkIterable<SearchDataTablesResponse> {
    private final ConnectClient client;
    private final SearchDataTablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchDataTablesIterable(ConnectClient client, SearchDataTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchDataTablesResponseFetcher();
    }

    public Iterator<SearchDataTablesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataTable> dataTables() {
        Function<SearchDataTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataTables() != null) {
                return response.dataTables().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchDataTablesResponseFetcher
    implements SyncPageFetcher<SearchDataTablesResponse> {
        private SearchDataTablesResponseFetcher() {
        }

        public boolean hasNextPage(SearchDataTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchDataTablesResponse nextPage(SearchDataTablesResponse previousPage) {
            if (previousPage == null) {
                return SearchDataTablesIterable.this.client.searchDataTables(SearchDataTablesIterable.this.firstRequest);
            }
            return SearchDataTablesIterable.this.client.searchDataTables((SearchDataTablesRequest)((Object)SearchDataTablesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

