/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.FlowModule;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileFlowModulesResponse;

public class ListSecurityProfileFlowModulesPublisher
implements SdkPublisher<ListSecurityProfileFlowModulesResponse> {
    private final ConnectAsyncClient client;
    private final ListSecurityProfileFlowModulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSecurityProfileFlowModulesPublisher(ConnectAsyncClient client, ListSecurityProfileFlowModulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSecurityProfileFlowModulesPublisher(ConnectAsyncClient client, ListSecurityProfileFlowModulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSecurityProfileFlowModulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSecurityProfileFlowModulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowModule> allowedFlowModules() {
        Function<ListSecurityProfileFlowModulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.allowedFlowModules() != null) {
                return response.allowedFlowModules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSecurityProfileFlowModulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSecurityProfileFlowModulesResponseFetcher
    implements AsyncPageFetcher<ListSecurityProfileFlowModulesResponse> {
        private ListSecurityProfileFlowModulesResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityProfileFlowModulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSecurityProfileFlowModulesResponse> nextPage(ListSecurityProfileFlowModulesResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityProfileFlowModulesPublisher.this.client.listSecurityProfileFlowModules(ListSecurityProfileFlowModulesPublisher.this.firstRequest);
            }
            return ListSecurityProfileFlowModulesPublisher.this.client.listSecurityProfileFlowModules((ListSecurityProfileFlowModulesRequest)((Object)ListSecurityProfileFlowModulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

