/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.DataTableSummary;
import software.amazon.awssdk.services.connect.model.ListDataTablesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTablesResponse;

public class ListDataTablesPublisher
implements SdkPublisher<ListDataTablesResponse> {
    private final ConnectAsyncClient client;
    private final ListDataTablesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataTablesPublisher(ConnectAsyncClient client, ListDataTablesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataTablesPublisher(ConnectAsyncClient client, ListDataTablesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataTablesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataTablesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataTableSummary> dataTableSummaryList() {
        Function<ListDataTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataTableSummaryList() != null) {
                return response.dataTableSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataTablesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataTablesResponseFetcher
    implements AsyncPageFetcher<ListDataTablesResponse> {
        private ListDataTablesResponseFetcher() {
        }

        public boolean hasNextPage(ListDataTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataTablesResponse> nextPage(ListDataTablesResponse previousPage) {
            if (previousPage == null) {
                return ListDataTablesPublisher.this.client.listDataTables(ListDataTablesPublisher.this.firstRequest);
            }
            return ListDataTablesPublisher.this.client.listDataTables((ListDataTablesRequest)((Object)ListDataTablesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

