/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.WorkspaceThemeImages;
import software.amazon.awssdk.services.connect.model.WorkspaceThemePalette;
import software.amazon.awssdk.services.connect.model.WorkspaceThemeTypography;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceThemeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceThemeConfig> {
    private static final SdkField<WorkspaceThemePalette> PALETTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Palette").getter(WorkspaceThemeConfig.getter(WorkspaceThemeConfig::palette)).setter(WorkspaceThemeConfig.setter(Builder::palette)).constructor(WorkspaceThemePalette::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Palette").build()}).build();
    private static final SdkField<WorkspaceThemeImages> IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Images").getter(WorkspaceThemeConfig.getter(WorkspaceThemeConfig::images)).setter(WorkspaceThemeConfig.setter(Builder::images)).constructor(WorkspaceThemeImages::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Images").build()}).build();
    private static final SdkField<WorkspaceThemeTypography> TYPOGRAPHY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Typography").getter(WorkspaceThemeConfig.getter(WorkspaceThemeConfig::typography)).setter(WorkspaceThemeConfig.setter(Builder::typography)).constructor(WorkspaceThemeTypography::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Typography").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PALETTE_FIELD, IMAGES_FIELD, TYPOGRAPHY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkspaceThemeConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final WorkspaceThemePalette palette;
    private final WorkspaceThemeImages images;
    private final WorkspaceThemeTypography typography;

    private WorkspaceThemeConfig(BuilderImpl builder) {
        this.palette = builder.palette;
        this.images = builder.images;
        this.typography = builder.typography;
    }

    public final WorkspaceThemePalette palette() {
        return this.palette;
    }

    public final WorkspaceThemeImages images() {
        return this.images;
    }

    public final WorkspaceThemeTypography typography() {
        return this.typography;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.palette());
        hashCode = 31 * hashCode + Objects.hashCode(this.images());
        hashCode = 31 * hashCode + Objects.hashCode(this.typography());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceThemeConfig)) {
            return false;
        }
        WorkspaceThemeConfig other = (WorkspaceThemeConfig)obj;
        return Objects.equals(this.palette(), other.palette()) && Objects.equals(this.images(), other.images()) && Objects.equals(this.typography(), other.typography());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspaceThemeConfig").add("Palette", (Object)this.palette()).add("Images", (Object)this.images()).add("Typography", (Object)this.typography()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Palette": {
                return Optional.ofNullable(clazz.cast(this.palette()));
            }
            case "Images": {
                return Optional.ofNullable(clazz.cast(this.images()));
            }
            case "Typography": {
                return Optional.ofNullable(clazz.cast(this.typography()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Palette", PALETTE_FIELD);
        map.put("Images", IMAGES_FIELD);
        map.put("Typography", TYPOGRAPHY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceThemeConfig, T> g) {
        return obj -> g.apply((WorkspaceThemeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WorkspaceThemePalette palette;
        private WorkspaceThemeImages images;
        private WorkspaceThemeTypography typography;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceThemeConfig model) {
            this.palette(model.palette);
            this.images(model.images);
            this.typography(model.typography);
        }

        public final WorkspaceThemePalette.Builder getPalette() {
            return this.palette != null ? this.palette.toBuilder() : null;
        }

        public final void setPalette(WorkspaceThemePalette.BuilderImpl palette) {
            this.palette = palette != null ? palette.build() : null;
        }

        @Override
        public final Builder palette(WorkspaceThemePalette palette) {
            this.palette = palette;
            return this;
        }

        public final WorkspaceThemeImages.Builder getImages() {
            return this.images != null ? this.images.toBuilder() : null;
        }

        public final void setImages(WorkspaceThemeImages.BuilderImpl images) {
            this.images = images != null ? images.build() : null;
        }

        @Override
        public final Builder images(WorkspaceThemeImages images) {
            this.images = images;
            return this;
        }

        public final WorkspaceThemeTypography.Builder getTypography() {
            return this.typography != null ? this.typography.toBuilder() : null;
        }

        public final void setTypography(WorkspaceThemeTypography.BuilderImpl typography) {
            this.typography = typography != null ? typography.build() : null;
        }

        @Override
        public final Builder typography(WorkspaceThemeTypography typography) {
            this.typography = typography;
            return this;
        }

        public WorkspaceThemeConfig build() {
            return new WorkspaceThemeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceThemeConfig> {
        public Builder palette(WorkspaceThemePalette var1);

        default public Builder palette(Consumer<WorkspaceThemePalette.Builder> palette) {
            return this.palette((WorkspaceThemePalette)((WorkspaceThemePalette.Builder)WorkspaceThemePalette.builder().applyMutation(palette)).build());
        }

        public Builder images(WorkspaceThemeImages var1);

        default public Builder images(Consumer<WorkspaceThemeImages.Builder> images) {
            return this.images((WorkspaceThemeImages)((WorkspaceThemeImages.Builder)WorkspaceThemeImages.builder().applyMutation(images)).build());
        }

        public Builder typography(WorkspaceThemeTypography var1);

        default public Builder typography(Consumer<WorkspaceThemeTypography.Builder> typography) {
            return this.typography((WorkspaceThemeTypography)((WorkspaceThemeTypography.Builder)WorkspaceThemeTypography.builder().applyMutation(typography)).build());
        }
    }
}

