/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.DataTableLockLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataTableMetadataRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateDataTableMetadataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateDataTableMetadataRequest.getter(UpdateDataTableMetadataRequest::instanceId)).setter(UpdateDataTableMetadataRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> DATA_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTableId").getter(UpdateDataTableMetadataRequest.getter(UpdateDataTableMetadataRequest::dataTableId)).setter(UpdateDataTableMetadataRequest.setter(Builder::dataTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataTableId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateDataTableMetadataRequest.getter(UpdateDataTableMetadataRequest::name)).setter(UpdateDataTableMetadataRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateDataTableMetadataRequest.getter(UpdateDataTableMetadataRequest::description)).setter(UpdateDataTableMetadataRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> VALUE_LOCK_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueLockLevel").getter(UpdateDataTableMetadataRequest.getter(UpdateDataTableMetadataRequest::valueLockLevelAsString)).setter(UpdateDataTableMetadataRequest.setter(Builder::valueLockLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueLockLevel").build()}).build();
    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeZone").getter(UpdateDataTableMetadataRequest.getter(UpdateDataTableMetadataRequest::timeZone)).setter(UpdateDataTableMetadataRequest.setter(Builder::timeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, DATA_TABLE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, VALUE_LOCK_LEVEL_FIELD, TIME_ZONE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDataTableMetadataRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String dataTableId;
    private final String name;
    private final String description;
    private final String valueLockLevel;
    private final String timeZone;

    private UpdateDataTableMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.dataTableId = builder.dataTableId;
        this.name = builder.name;
        this.description = builder.description;
        this.valueLockLevel = builder.valueLockLevel;
        this.timeZone = builder.timeZone;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String dataTableId() {
        return this.dataTableId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final DataTableLockLevel valueLockLevel() {
        return DataTableLockLevel.fromValue(this.valueLockLevel);
    }

    public final String valueLockLevelAsString() {
        return this.valueLockLevel;
    }

    public final String timeZone() {
        return this.timeZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueLockLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataTableMetadataRequest)) {
            return false;
        }
        UpdateDataTableMetadataRequest other = (UpdateDataTableMetadataRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.dataTableId(), other.dataTableId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.valueLockLevelAsString(), other.valueLockLevelAsString()) && Objects.equals(this.timeZone(), other.timeZone());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDataTableMetadataRequest").add("InstanceId", (Object)this.instanceId()).add("DataTableId", (Object)this.dataTableId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ValueLockLevel", (Object)this.valueLockLevelAsString()).add("TimeZone", (Object)this.timeZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "DataTableId": {
                return Optional.ofNullable(clazz.cast(this.dataTableId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ValueLockLevel": {
                return Optional.ofNullable(clazz.cast(this.valueLockLevelAsString()));
            }
            case "TimeZone": {
                return Optional.ofNullable(clazz.cast(this.timeZone()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("DataTableId", DATA_TABLE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ValueLockLevel", VALUE_LOCK_LEVEL_FIELD);
        map.put("TimeZone", TIME_ZONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataTableMetadataRequest, T> g) {
        return obj -> g.apply((UpdateDataTableMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String dataTableId;
        private String name;
        private String description;
        private String valueLockLevel;
        private String timeZone;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataTableMetadataRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.dataTableId(model.dataTableId);
            this.name(model.name);
            this.description(model.description);
            this.valueLockLevel(model.valueLockLevel);
            this.timeZone(model.timeZone);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDataTableId() {
            return this.dataTableId;
        }

        public final void setDataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
        }

        @Override
        public final Builder dataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getValueLockLevel() {
            return this.valueLockLevel;
        }

        public final void setValueLockLevel(String valueLockLevel) {
            this.valueLockLevel = valueLockLevel;
        }

        @Override
        public final Builder valueLockLevel(String valueLockLevel) {
            this.valueLockLevel = valueLockLevel;
            return this;
        }

        @Override
        public final Builder valueLockLevel(DataTableLockLevel valueLockLevel) {
            this.valueLockLevel(valueLockLevel == null ? null : valueLockLevel.toString());
            return this;
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataTableMetadataRequest build() {
            return new UpdateDataTableMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataTableMetadataRequest> {
        public Builder instanceId(String var1);

        public Builder dataTableId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder valueLockLevel(String var1);

        public Builder valueLockLevel(DataTableLockLevel var1);

        public Builder timeZone(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

