/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AgentResourceIdListCopier;
import software.amazon.awssdk.services.connect.model.SearchContactsMatchType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchableAgentCriteriaStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchableAgentCriteriaStep> {
    private static final SdkField<List<String>> AGENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentIds").getter(SearchableAgentCriteriaStep.getter(SearchableAgentCriteriaStep::agentIds)).setter(SearchableAgentCriteriaStep.setter(Builder::agentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MATCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchType").getter(SearchableAgentCriteriaStep.getter(SearchableAgentCriteriaStep::matchTypeAsString)).setter(SearchableAgentCriteriaStep.setter(Builder::matchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_IDS_FIELD, MATCH_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchableAgentCriteriaStep.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> agentIds;
    private final String matchType;

    private SearchableAgentCriteriaStep(BuilderImpl builder) {
        this.agentIds = builder.agentIds;
        this.matchType = builder.matchType;
    }

    public final boolean hasAgentIds() {
        return this.agentIds != null && !(this.agentIds instanceof SdkAutoConstructList);
    }

    public final List<String> agentIds() {
        return this.agentIds;
    }

    public final SearchContactsMatchType matchType() {
        return SearchContactsMatchType.fromValue(this.matchType);
    }

    public final String matchTypeAsString() {
        return this.matchType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentIds() ? this.agentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.matchTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchableAgentCriteriaStep)) {
            return false;
        }
        SearchableAgentCriteriaStep other = (SearchableAgentCriteriaStep)obj;
        return this.hasAgentIds() == other.hasAgentIds() && Objects.equals(this.agentIds(), other.agentIds()) && Objects.equals(this.matchTypeAsString(), other.matchTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SearchableAgentCriteriaStep").add("AgentIds", this.hasAgentIds() ? this.agentIds() : null).add("MatchType", (Object)this.matchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentIds": {
                return Optional.ofNullable(clazz.cast(this.agentIds()));
            }
            case "MatchType": {
                return Optional.ofNullable(clazz.cast(this.matchTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AgentIds", AGENT_IDS_FIELD);
        map.put("MatchType", MATCH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchableAgentCriteriaStep, T> g) {
        return obj -> g.apply((SearchableAgentCriteriaStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> agentIds = DefaultSdkAutoConstructList.getInstance();
        private String matchType;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchableAgentCriteriaStep model) {
            this.agentIds(model.agentIds);
            this.matchType(model.matchType);
        }

        public final Collection<String> getAgentIds() {
            if (this.agentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentIds;
        }

        public final void setAgentIds(Collection<String> agentIds) {
            this.agentIds = AgentResourceIdListCopier.copy(agentIds);
        }

        @Override
        public final Builder agentIds(Collection<String> agentIds) {
            this.agentIds = AgentResourceIdListCopier.copy(agentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentIds(String ... agentIds) {
            this.agentIds(Arrays.asList(agentIds));
            return this;
        }

        public final String getMatchType() {
            return this.matchType;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(SearchContactsMatchType matchType) {
            this.matchType(matchType == null ? null : matchType.toString());
            return this;
        }

        public SearchableAgentCriteriaStep build() {
            return new SearchableAgentCriteriaStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchableAgentCriteriaStep> {
        public Builder agentIds(Collection<String> var1);

        public Builder agentIds(String ... var1);

        public Builder matchType(String var1);

        public Builder matchType(SearchContactsMatchType var1);
    }
}

