/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.EvaluationFormSearchSummary;
import software.amazon.awssdk.services.connect.model.EvaluationFormSearchSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchEvaluationFormsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchEvaluationFormsResponse> {
    private static final SdkField<List<EvaluationFormSearchSummary>> EVALUATION_FORM_SEARCH_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EvaluationFormSearchSummaryList").getter(SearchEvaluationFormsResponse.getter(SearchEvaluationFormsResponse::evaluationFormSearchSummaryList)).setter(SearchEvaluationFormsResponse.setter(Builder::evaluationFormSearchSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormSearchSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationFormSearchSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchEvaluationFormsResponse.getter(SearchEvaluationFormsResponse::nextToken)).setter(SearchEvaluationFormsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(SearchEvaluationFormsResponse.getter(SearchEvaluationFormsResponse::approximateTotalCount)).setter(SearchEvaluationFormsResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_FORM_SEARCH_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchEvaluationFormsResponse.memberNameToFieldInitializer();
    private final List<EvaluationFormSearchSummary> evaluationFormSearchSummaryList;
    private final String nextToken;
    private final Long approximateTotalCount;

    private SearchEvaluationFormsResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationFormSearchSummaryList = builder.evaluationFormSearchSummaryList;
        this.nextToken = builder.nextToken;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final boolean hasEvaluationFormSearchSummaryList() {
        return this.evaluationFormSearchSummaryList != null && !(this.evaluationFormSearchSummaryList instanceof SdkAutoConstructList);
    }

    public final List<EvaluationFormSearchSummary> evaluationFormSearchSummaryList() {
        return this.evaluationFormSearchSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluationFormSearchSummaryList() ? this.evaluationFormSearchSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchEvaluationFormsResponse)) {
            return false;
        }
        SearchEvaluationFormsResponse other = (SearchEvaluationFormsResponse)((Object)obj);
        return this.hasEvaluationFormSearchSummaryList() == other.hasEvaluationFormSearchSummaryList() && Objects.equals(this.evaluationFormSearchSummaryList(), other.evaluationFormSearchSummaryList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchEvaluationFormsResponse").add("EvaluationFormSearchSummaryList", this.hasEvaluationFormSearchSummaryList() ? this.evaluationFormSearchSummaryList() : null).add("NextToken", (Object)this.nextToken()).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationFormSearchSummaryList": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormSearchSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EvaluationFormSearchSummaryList", EVALUATION_FORM_SEARCH_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchEvaluationFormsResponse, T> g) {
        return obj -> g.apply((SearchEvaluationFormsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<EvaluationFormSearchSummary> evaluationFormSearchSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchEvaluationFormsResponse model) {
            super(model);
            this.evaluationFormSearchSummaryList(model.evaluationFormSearchSummaryList);
            this.nextToken(model.nextToken);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final List<EvaluationFormSearchSummary.Builder> getEvaluationFormSearchSummaryList() {
            List<EvaluationFormSearchSummary.Builder> result = EvaluationFormSearchSummaryListCopier.copyToBuilder(this.evaluationFormSearchSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluationFormSearchSummaryList(Collection<EvaluationFormSearchSummary.BuilderImpl> evaluationFormSearchSummaryList) {
            this.evaluationFormSearchSummaryList = EvaluationFormSearchSummaryListCopier.copyFromBuilder(evaluationFormSearchSummaryList);
        }

        @Override
        public final Builder evaluationFormSearchSummaryList(Collection<EvaluationFormSearchSummary> evaluationFormSearchSummaryList) {
            this.evaluationFormSearchSummaryList = EvaluationFormSearchSummaryListCopier.copy(evaluationFormSearchSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationFormSearchSummaryList(EvaluationFormSearchSummary ... evaluationFormSearchSummaryList) {
            this.evaluationFormSearchSummaryList(Arrays.asList(evaluationFormSearchSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationFormSearchSummaryList(Consumer<EvaluationFormSearchSummary.Builder> ... evaluationFormSearchSummaryList) {
            this.evaluationFormSearchSummaryList(Stream.of(evaluationFormSearchSummaryList).map(c -> (EvaluationFormSearchSummary)((EvaluationFormSearchSummary.Builder)EvaluationFormSearchSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchEvaluationFormsResponse build() {
            return new SearchEvaluationFormsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchEvaluationFormsResponse> {
        public Builder evaluationFormSearchSummaryList(Collection<EvaluationFormSearchSummary> var1);

        public Builder evaluationFormSearchSummaryList(EvaluationFormSearchSummary ... var1);

        public Builder evaluationFormSearchSummaryList(Consumer<EvaluationFormSearchSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder approximateTotalCount(Long var1);
    }
}

