/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AttachmentReference;
import software.amazon.awssdk.services.connect.model.DateReference;
import software.amazon.awssdk.services.connect.model.EmailMessageReference;
import software.amazon.awssdk.services.connect.model.EmailReference;
import software.amazon.awssdk.services.connect.model.NumberReference;
import software.amazon.awssdk.services.connect.model.StringReference;
import software.amazon.awssdk.services.connect.model.UrlReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferenceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReferenceSummary> {
    private static final SdkField<UrlReference> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Url").getter(ReferenceSummary.getter(ReferenceSummary::url)).setter(ReferenceSummary.setter(Builder::url)).constructor(UrlReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<AttachmentReference> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachment").getter(ReferenceSummary.getter(ReferenceSummary::attachment)).setter(ReferenceSummary.setter(Builder::attachment)).constructor(AttachmentReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()}).build();
    private static final SdkField<EmailMessageReference> EMAIL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmailMessage").getter(ReferenceSummary.getter(ReferenceSummary::emailMessage)).setter(ReferenceSummary.setter(Builder::emailMessage)).constructor(EmailMessageReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()}).build();
    private static final SdkField<EmailMessageReference> EMAIL_MESSAGE_PLAIN_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmailMessagePlainText").getter(ReferenceSummary.getter(ReferenceSummary::emailMessagePlainText)).setter(ReferenceSummary.setter(Builder::emailMessagePlainText)).constructor(EmailMessageReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessagePlainText").build()}).build();
    private static final SdkField<StringReference> STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("String").getter(ReferenceSummary.getter(ReferenceSummary::string)).setter(ReferenceSummary.setter(Builder::string)).constructor(StringReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("String").build()}).build();
    private static final SdkField<NumberReference> NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Number").getter(ReferenceSummary.getter(ReferenceSummary::number)).setter(ReferenceSummary.setter(Builder::number)).constructor(NumberReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Number").build()}).build();
    private static final SdkField<DateReference> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Date").getter(ReferenceSummary.getter(ReferenceSummary::date)).setter(ReferenceSummary.setter(Builder::date)).constructor(DateReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()}).build();
    private static final SdkField<EmailReference> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Email").getter(ReferenceSummary.getter(ReferenceSummary::email)).setter(ReferenceSummary.setter(Builder::email)).constructor(EmailReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, ATTACHMENT_FIELD, EMAIL_MESSAGE_FIELD, EMAIL_MESSAGE_PLAIN_TEXT_FIELD, STRING_FIELD, NUMBER_FIELD, DATE_FIELD, EMAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReferenceSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final UrlReference url;
    private final AttachmentReference attachment;
    private final EmailMessageReference emailMessage;
    private final EmailMessageReference emailMessagePlainText;
    private final StringReference string;
    private final NumberReference number;
    private final DateReference date;
    private final EmailReference email;
    private final Type type;

    private ReferenceSummary(BuilderImpl builder) {
        this.url = builder.url;
        this.attachment = builder.attachment;
        this.emailMessage = builder.emailMessage;
        this.emailMessagePlainText = builder.emailMessagePlainText;
        this.string = builder.string;
        this.number = builder.number;
        this.date = builder.date;
        this.email = builder.email;
        this.type = builder.type;
    }

    public final UrlReference url() {
        return this.url;
    }

    public final AttachmentReference attachment() {
        return this.attachment;
    }

    public final EmailMessageReference emailMessage() {
        return this.emailMessage;
    }

    public final EmailMessageReference emailMessagePlainText() {
        return this.emailMessagePlainText;
    }

    public final StringReference string() {
        return this.string;
    }

    public final NumberReference number() {
        return this.number;
    }

    public final DateReference date() {
        return this.date;
    }

    public final EmailReference email() {
        return this.email;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessagePlainText());
        hashCode = 31 * hashCode + Objects.hashCode(this.string());
        hashCode = 31 * hashCode + Objects.hashCode(this.number());
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceSummary)) {
            return false;
        }
        ReferenceSummary other = (ReferenceSummary)obj;
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.emailMessage(), other.emailMessage()) && Objects.equals(this.emailMessagePlainText(), other.emailMessagePlainText()) && Objects.equals(this.string(), other.string()) && Objects.equals(this.number(), other.number()) && Objects.equals(this.date(), other.date()) && Objects.equals(this.email(), other.email());
    }

    public final String toString() {
        return ToString.builder((String)"ReferenceSummary").add("Url", (Object)this.url()).add("Attachment", (Object)this.attachment()).add("EmailMessage", (Object)this.emailMessage()).add("EmailMessagePlainText", (Object)this.emailMessagePlainText()).add("String", (Object)this.string()).add("Number", (Object)this.number()).add("Date", (Object)this.date()).add("Email", (Object)this.email()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "EmailMessage": {
                return Optional.ofNullable(clazz.cast(this.emailMessage()));
            }
            case "EmailMessagePlainText": {
                return Optional.ofNullable(clazz.cast(this.emailMessagePlainText()));
            }
            case "String": {
                return Optional.ofNullable(clazz.cast(this.string()));
            }
            case "Number": {
                return Optional.ofNullable(clazz.cast(this.number()));
            }
            case "Date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
        }
        return Optional.empty();
    }

    public static ReferenceSummary fromUrl(UrlReference url) {
        return (ReferenceSummary)ReferenceSummary.builder().url(url).build();
    }

    public static ReferenceSummary fromUrl(Consumer<UrlReference.Builder> url) {
        UrlReference.Builder builder = UrlReference.builder();
        url.accept(builder);
        return ReferenceSummary.fromUrl((UrlReference)builder.build());
    }

    public static ReferenceSummary fromAttachment(AttachmentReference attachment) {
        return (ReferenceSummary)ReferenceSummary.builder().attachment(attachment).build();
    }

    public static ReferenceSummary fromAttachment(Consumer<AttachmentReference.Builder> attachment) {
        AttachmentReference.Builder builder = AttachmentReference.builder();
        attachment.accept(builder);
        return ReferenceSummary.fromAttachment((AttachmentReference)builder.build());
    }

    public static ReferenceSummary fromEmailMessage(EmailMessageReference emailMessage) {
        return (ReferenceSummary)ReferenceSummary.builder().emailMessage(emailMessage).build();
    }

    public static ReferenceSummary fromEmailMessage(Consumer<EmailMessageReference.Builder> emailMessage) {
        EmailMessageReference.Builder builder = EmailMessageReference.builder();
        emailMessage.accept(builder);
        return ReferenceSummary.fromEmailMessage((EmailMessageReference)builder.build());
    }

    public static ReferenceSummary fromEmailMessagePlainText(EmailMessageReference emailMessagePlainText) {
        return (ReferenceSummary)ReferenceSummary.builder().emailMessagePlainText(emailMessagePlainText).build();
    }

    public static ReferenceSummary fromEmailMessagePlainText(Consumer<EmailMessageReference.Builder> emailMessagePlainText) {
        EmailMessageReference.Builder builder = EmailMessageReference.builder();
        emailMessagePlainText.accept(builder);
        return ReferenceSummary.fromEmailMessagePlainText((EmailMessageReference)builder.build());
    }

    public static ReferenceSummary fromString(StringReference string) {
        return (ReferenceSummary)ReferenceSummary.builder().string(string).build();
    }

    public static ReferenceSummary fromString(Consumer<StringReference.Builder> string) {
        StringReference.Builder builder = StringReference.builder();
        string.accept(builder);
        return ReferenceSummary.fromString((StringReference)builder.build());
    }

    public static ReferenceSummary fromNumber(NumberReference number) {
        return (ReferenceSummary)ReferenceSummary.builder().number(number).build();
    }

    public static ReferenceSummary fromNumber(Consumer<NumberReference.Builder> number) {
        NumberReference.Builder builder = NumberReference.builder();
        number.accept(builder);
        return ReferenceSummary.fromNumber((NumberReference)builder.build());
    }

    public static ReferenceSummary fromDate(DateReference date) {
        return (ReferenceSummary)ReferenceSummary.builder().date(date).build();
    }

    public static ReferenceSummary fromDate(Consumer<DateReference.Builder> date) {
        DateReference.Builder builder = DateReference.builder();
        date.accept(builder);
        return ReferenceSummary.fromDate((DateReference)builder.build());
    }

    public static ReferenceSummary fromEmail(EmailReference email) {
        return (ReferenceSummary)ReferenceSummary.builder().email(email).build();
    }

    public static ReferenceSummary fromEmail(Consumer<EmailReference.Builder> email) {
        EmailReference.Builder builder = EmailReference.builder();
        email.accept(builder);
        return ReferenceSummary.fromEmail((EmailReference)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Url", URL_FIELD);
        map.put("Attachment", ATTACHMENT_FIELD);
        map.put("EmailMessage", EMAIL_MESSAGE_FIELD);
        map.put("EmailMessagePlainText", EMAIL_MESSAGE_PLAIN_TEXT_FIELD);
        map.put("String", STRING_FIELD);
        map.put("Number", NUMBER_FIELD);
        map.put("Date", DATE_FIELD);
        map.put("Email", EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReferenceSummary, T> g) {
        return obj -> g.apply((ReferenceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        URL,
        ATTACHMENT,
        EMAIL_MESSAGE,
        EMAIL_MESSAGE_PLAIN_TEXT,
        STRING,
        NUMBER,
        DATE,
        EMAIL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private UrlReference url;
        private AttachmentReference attachment;
        private EmailMessageReference emailMessage;
        private EmailMessageReference emailMessagePlainText;
        private StringReference string;
        private NumberReference number;
        private DateReference date;
        private EmailReference email;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceSummary model) {
            this.url(model.url);
            this.attachment(model.attachment);
            this.emailMessage(model.emailMessage);
            this.emailMessagePlainText(model.emailMessagePlainText);
            this.string(model.string);
            this.number(model.number);
            this.date(model.date);
            this.email(model.email);
        }

        public final UrlReference.Builder getUrl() {
            return this.url != null ? this.url.toBuilder() : null;
        }

        public final void setUrl(UrlReference.BuilderImpl url) {
            UrlReference oldValue = this.url;
            this.url = url != null ? url.build() : null;
            this.handleUnionValueChange(Type.URL, oldValue, this.url);
        }

        @Override
        public final Builder url(UrlReference url) {
            UrlReference oldValue = this.url;
            this.url = url;
            this.handleUnionValueChange(Type.URL, oldValue, this.url);
            return this;
        }

        public final AttachmentReference.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        public final void setAttachment(AttachmentReference.BuilderImpl attachment) {
            AttachmentReference oldValue = this.attachment;
            this.attachment = attachment != null ? attachment.build() : null;
            this.handleUnionValueChange(Type.ATTACHMENT, oldValue, this.attachment);
        }

        @Override
        public final Builder attachment(AttachmentReference attachment) {
            AttachmentReference oldValue = this.attachment;
            this.attachment = attachment;
            this.handleUnionValueChange(Type.ATTACHMENT, oldValue, this.attachment);
            return this;
        }

        public final EmailMessageReference.Builder getEmailMessage() {
            return this.emailMessage != null ? this.emailMessage.toBuilder() : null;
        }

        public final void setEmailMessage(EmailMessageReference.BuilderImpl emailMessage) {
            EmailMessageReference oldValue = this.emailMessage;
            this.emailMessage = emailMessage != null ? emailMessage.build() : null;
            this.handleUnionValueChange(Type.EMAIL_MESSAGE, oldValue, this.emailMessage);
        }

        @Override
        public final Builder emailMessage(EmailMessageReference emailMessage) {
            EmailMessageReference oldValue = this.emailMessage;
            this.emailMessage = emailMessage;
            this.handleUnionValueChange(Type.EMAIL_MESSAGE, oldValue, this.emailMessage);
            return this;
        }

        public final EmailMessageReference.Builder getEmailMessagePlainText() {
            return this.emailMessagePlainText != null ? this.emailMessagePlainText.toBuilder() : null;
        }

        public final void setEmailMessagePlainText(EmailMessageReference.BuilderImpl emailMessagePlainText) {
            EmailMessageReference oldValue = this.emailMessagePlainText;
            this.emailMessagePlainText = emailMessagePlainText != null ? emailMessagePlainText.build() : null;
            this.handleUnionValueChange(Type.EMAIL_MESSAGE_PLAIN_TEXT, oldValue, this.emailMessagePlainText);
        }

        @Override
        public final Builder emailMessagePlainText(EmailMessageReference emailMessagePlainText) {
            EmailMessageReference oldValue = this.emailMessagePlainText;
            this.emailMessagePlainText = emailMessagePlainText;
            this.handleUnionValueChange(Type.EMAIL_MESSAGE_PLAIN_TEXT, oldValue, this.emailMessagePlainText);
            return this;
        }

        public final StringReference.Builder getString() {
            return this.string != null ? this.string.toBuilder() : null;
        }

        public final void setString(StringReference.BuilderImpl string) {
            StringReference oldValue = this.string;
            this.string = string != null ? string.build() : null;
            this.handleUnionValueChange(Type.STRING, oldValue, this.string);
        }

        @Override
        public final Builder string(StringReference string) {
            StringReference oldValue = this.string;
            this.string = string;
            this.handleUnionValueChange(Type.STRING, oldValue, this.string);
            return this;
        }

        public final NumberReference.Builder getNumber() {
            return this.number != null ? this.number.toBuilder() : null;
        }

        public final void setNumber(NumberReference.BuilderImpl number) {
            NumberReference oldValue = this.number;
            this.number = number != null ? number.build() : null;
            this.handleUnionValueChange(Type.NUMBER, oldValue, this.number);
        }

        @Override
        public final Builder number(NumberReference number) {
            NumberReference oldValue = this.number;
            this.number = number;
            this.handleUnionValueChange(Type.NUMBER, oldValue, this.number);
            return this;
        }

        public final DateReference.Builder getDate() {
            return this.date != null ? this.date.toBuilder() : null;
        }

        public final void setDate(DateReference.BuilderImpl date) {
            DateReference oldValue = this.date;
            this.date = date != null ? date.build() : null;
            this.handleUnionValueChange(Type.DATE, oldValue, this.date);
        }

        @Override
        public final Builder date(DateReference date) {
            DateReference oldValue = this.date;
            this.date = date;
            this.handleUnionValueChange(Type.DATE, oldValue, this.date);
            return this;
        }

        public final EmailReference.Builder getEmail() {
            return this.email != null ? this.email.toBuilder() : null;
        }

        public final void setEmail(EmailReference.BuilderImpl email) {
            EmailReference oldValue = this.email;
            this.email = email != null ? email.build() : null;
            this.handleUnionValueChange(Type.EMAIL, oldValue, this.email);
        }

        @Override
        public final Builder email(EmailReference email) {
            EmailReference oldValue = this.email;
            this.email = email;
            this.handleUnionValueChange(Type.EMAIL, oldValue, this.email);
            return this;
        }

        public ReferenceSummary build() {
            return new ReferenceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReferenceSummary> {
        public Builder url(UrlReference var1);

        default public Builder url(Consumer<UrlReference.Builder> url) {
            return this.url((UrlReference)((UrlReference.Builder)UrlReference.builder().applyMutation(url)).build());
        }

        public Builder attachment(AttachmentReference var1);

        default public Builder attachment(Consumer<AttachmentReference.Builder> attachment) {
            return this.attachment((AttachmentReference)((AttachmentReference.Builder)AttachmentReference.builder().applyMutation(attachment)).build());
        }

        public Builder emailMessage(EmailMessageReference var1);

        default public Builder emailMessage(Consumer<EmailMessageReference.Builder> emailMessage) {
            return this.emailMessage((EmailMessageReference)((EmailMessageReference.Builder)EmailMessageReference.builder().applyMutation(emailMessage)).build());
        }

        public Builder emailMessagePlainText(EmailMessageReference var1);

        default public Builder emailMessagePlainText(Consumer<EmailMessageReference.Builder> emailMessagePlainText) {
            return this.emailMessagePlainText((EmailMessageReference)((EmailMessageReference.Builder)EmailMessageReference.builder().applyMutation(emailMessagePlainText)).build());
        }

        public Builder string(StringReference var1);

        default public Builder string(Consumer<StringReference.Builder> string) {
            return this.string((StringReference)((StringReference.Builder)StringReference.builder().applyMutation(string)).build());
        }

        public Builder number(NumberReference var1);

        default public Builder number(Consumer<NumberReference.Builder> number) {
            return this.number((NumberReference)((NumberReference.Builder)NumberReference.builder().applyMutation(number)).build());
        }

        public Builder date(DateReference var1);

        default public Builder date(Consumer<DateReference.Builder> date) {
            return this.date((DateReference)((DateReference.Builder)DateReference.builder().applyMutation(date)).build());
        }

        public Builder email(EmailReference var1);

        default public Builder email(Consumer<EmailReference.Builder> email) {
            return this.email((EmailReference)((EmailReference.Builder)EmailReference.builder().applyMutation(email)).build());
        }
    }
}

