/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.NextContactMetadata;
import software.amazon.awssdk.services.connect.model.NextContactType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NextContactEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NextContactEntry> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(NextContactEntry.getter(NextContactEntry::typeAsString)).setter(NextContactEntry.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<NextContactMetadata> NEXT_CONTACT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NextContactMetadata").getter(NextContactEntry.getter(NextContactEntry::nextContactMetadata)).setter(NextContactEntry.setter(Builder::nextContactMetadata)).constructor(NextContactMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextContactMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NEXT_CONTACT_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NextContactEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final NextContactMetadata nextContactMetadata;

    private NextContactEntry(BuilderImpl builder) {
        this.type = builder.type;
        this.nextContactMetadata = builder.nextContactMetadata;
    }

    public final NextContactType type() {
        return NextContactType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final NextContactMetadata nextContactMetadata() {
        return this.nextContactMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextContactMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NextContactEntry)) {
            return false;
        }
        NextContactEntry other = (NextContactEntry)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.nextContactMetadata(), other.nextContactMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"NextContactEntry").add("Type", (Object)this.typeAsString()).add("NextContactMetadata", (Object)this.nextContactMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "NextContactMetadata": {
                return Optional.ofNullable(clazz.cast(this.nextContactMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("NextContactMetadata", NEXT_CONTACT_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NextContactEntry, T> g) {
        return obj -> g.apply((NextContactEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private NextContactMetadata nextContactMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(NextContactEntry model) {
            this.type(model.type);
            this.nextContactMetadata(model.nextContactMetadata);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NextContactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final NextContactMetadata.Builder getNextContactMetadata() {
            return this.nextContactMetadata != null ? this.nextContactMetadata.toBuilder() : null;
        }

        public final void setNextContactMetadata(NextContactMetadata.BuilderImpl nextContactMetadata) {
            this.nextContactMetadata = nextContactMetadata != null ? nextContactMetadata.build() : null;
        }

        @Override
        public final Builder nextContactMetadata(NextContactMetadata nextContactMetadata) {
            this.nextContactMetadata = nextContactMetadata;
            return this;
        }

        public NextContactEntry build() {
            return new NextContactEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NextContactEntry> {
        public Builder type(String var1);

        public Builder type(NextContactType var1);

        public Builder nextContactMetadata(NextContactMetadata var1);

        default public Builder nextContactMetadata(Consumer<NextContactMetadata.Builder> nextContactMetadata) {
            return this.nextContactMetadata((NextContactMetadata)((NextContactMetadata.Builder)NextContactMetadata.builder().applyMutation(nextContactMetadata)).build());
        }
    }
}

