/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.MetricFilterValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricFilterV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricFilterV2> {
    private static final SdkField<String> METRIC_FILTER_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricFilterKey").getter(MetricFilterV2.getter(MetricFilterV2::metricFilterKey)).setter(MetricFilterV2.setter(Builder::metricFilterKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricFilterKey").build()}).build();
    private static final SdkField<List<String>> METRIC_FILTER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricFilterValues").getter(MetricFilterV2.getter(MetricFilterV2::metricFilterValues)).setter(MetricFilterV2.setter(Builder::metricFilterValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricFilterValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> NEGATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Negate").getter(MetricFilterV2.getter(MetricFilterV2::negate)).setter(MetricFilterV2.setter(Builder::negate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Negate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FILTER_KEY_FIELD, METRIC_FILTER_VALUES_FIELD, NEGATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricFilterV2.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metricFilterKey;
    private final List<String> metricFilterValues;
    private final Boolean negate;

    private MetricFilterV2(BuilderImpl builder) {
        this.metricFilterKey = builder.metricFilterKey;
        this.metricFilterValues = builder.metricFilterValues;
        this.negate = builder.negate;
    }

    public final String metricFilterKey() {
        return this.metricFilterKey;
    }

    public final boolean hasMetricFilterValues() {
        return this.metricFilterValues != null && !(this.metricFilterValues instanceof SdkAutoConstructList);
    }

    public final List<String> metricFilterValues() {
        return this.metricFilterValues;
    }

    public final Boolean negate() {
        return this.negate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricFilterKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricFilterValues() ? this.metricFilterValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.negate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricFilterV2)) {
            return false;
        }
        MetricFilterV2 other = (MetricFilterV2)obj;
        return Objects.equals(this.metricFilterKey(), other.metricFilterKey()) && this.hasMetricFilterValues() == other.hasMetricFilterValues() && Objects.equals(this.metricFilterValues(), other.metricFilterValues()) && Objects.equals(this.negate(), other.negate());
    }

    public final String toString() {
        return ToString.builder((String)"MetricFilterV2").add("MetricFilterKey", (Object)this.metricFilterKey()).add("MetricFilterValues", this.hasMetricFilterValues() ? this.metricFilterValues() : null).add("Negate", (Object)this.negate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricFilterKey": {
                return Optional.ofNullable(clazz.cast(this.metricFilterKey()));
            }
            case "MetricFilterValues": {
                return Optional.ofNullable(clazz.cast(this.metricFilterValues()));
            }
            case "Negate": {
                return Optional.ofNullable(clazz.cast(this.negate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricFilterKey", METRIC_FILTER_KEY_FIELD);
        map.put("MetricFilterValues", METRIC_FILTER_VALUES_FIELD);
        map.put("Negate", NEGATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricFilterV2, T> g) {
        return obj -> g.apply((MetricFilterV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricFilterKey;
        private List<String> metricFilterValues = DefaultSdkAutoConstructList.getInstance();
        private Boolean negate;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricFilterV2 model) {
            this.metricFilterKey(model.metricFilterKey);
            this.metricFilterValues(model.metricFilterValues);
            this.negate(model.negate);
        }

        public final String getMetricFilterKey() {
            return this.metricFilterKey;
        }

        public final void setMetricFilterKey(String metricFilterKey) {
            this.metricFilterKey = metricFilterKey;
        }

        @Override
        public final Builder metricFilterKey(String metricFilterKey) {
            this.metricFilterKey = metricFilterKey;
            return this;
        }

        public final Collection<String> getMetricFilterValues() {
            if (this.metricFilterValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricFilterValues;
        }

        public final void setMetricFilterValues(Collection<String> metricFilterValues) {
            this.metricFilterValues = MetricFilterValueListCopier.copy(metricFilterValues);
        }

        @Override
        public final Builder metricFilterValues(Collection<String> metricFilterValues) {
            this.metricFilterValues = MetricFilterValueListCopier.copy(metricFilterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricFilterValues(String ... metricFilterValues) {
            this.metricFilterValues(Arrays.asList(metricFilterValues));
            return this;
        }

        public final Boolean getNegate() {
            return this.negate;
        }

        public final void setNegate(Boolean negate) {
            this.negate = negate;
        }

        @Override
        public final Builder negate(Boolean negate) {
            this.negate = negate;
            return this;
        }

        public MetricFilterV2 build() {
            return new MetricFilterV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricFilterV2> {
        public Builder metricFilterKey(String var1);

        public Builder metricFilterValues(Collection<String> var1);

        public Builder metricFilterValues(String ... var1);

        public Builder negate(Boolean var1);
    }
}

