/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.SecurityProfileItem;
import software.amazon.awssdk.services.connect.model.SecurityProfiles100Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntitySecurityProfilesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListEntitySecurityProfilesResponse> {
    private static final SdkField<List<SecurityProfileItem>> SECURITY_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityProfiles").getter(ListEntitySecurityProfilesResponse.getter(ListEntitySecurityProfilesResponse::securityProfiles)).setter(ListEntitySecurityProfilesResponse.setter(Builder::securityProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityProfileItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEntitySecurityProfilesResponse.getter(ListEntitySecurityProfilesResponse::nextToken)).setter(ListEntitySecurityProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEntitySecurityProfilesResponse.memberNameToFieldInitializer();
    private final List<SecurityProfileItem> securityProfiles;
    private final String nextToken;

    private ListEntitySecurityProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfiles = builder.securityProfiles;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSecurityProfiles() {
        return this.securityProfiles != null && !(this.securityProfiles instanceof SdkAutoConstructList);
    }

    public final List<SecurityProfileItem> securityProfiles() {
        return this.securityProfiles;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityProfiles() ? this.securityProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitySecurityProfilesResponse)) {
            return false;
        }
        ListEntitySecurityProfilesResponse other = (ListEntitySecurityProfilesResponse)((Object)obj);
        return this.hasSecurityProfiles() == other.hasSecurityProfiles() && Objects.equals(this.securityProfiles(), other.securityProfiles()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEntitySecurityProfilesResponse").add("SecurityProfiles", this.hasSecurityProfiles() ? this.securityProfiles() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityProfiles": {
                return Optional.ofNullable(clazz.cast(this.securityProfiles()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SecurityProfiles", SECURITY_PROFILES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEntitySecurityProfilesResponse, T> g) {
        return obj -> g.apply((ListEntitySecurityProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<SecurityProfileItem> securityProfiles = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitySecurityProfilesResponse model) {
            super(model);
            this.securityProfiles(model.securityProfiles);
            this.nextToken(model.nextToken);
        }

        public final List<SecurityProfileItem.Builder> getSecurityProfiles() {
            List<SecurityProfileItem.Builder> result = SecurityProfiles100Copier.copyToBuilder(this.securityProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityProfiles(Collection<SecurityProfileItem.BuilderImpl> securityProfiles) {
            this.securityProfiles = SecurityProfiles100Copier.copyFromBuilder(securityProfiles);
        }

        @Override
        public final Builder securityProfiles(Collection<SecurityProfileItem> securityProfiles) {
            this.securityProfiles = SecurityProfiles100Copier.copy(securityProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfiles(SecurityProfileItem ... securityProfiles) {
            this.securityProfiles(Arrays.asList(securityProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfiles(Consumer<SecurityProfileItem.Builder> ... securityProfiles) {
            this.securityProfiles(Stream.of(securityProfiles).map(c -> (SecurityProfileItem)((SecurityProfileItem.Builder)SecurityProfileItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEntitySecurityProfilesResponse build() {
            return new ListEntitySecurityProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEntitySecurityProfilesResponse> {
        public Builder securityProfiles(Collection<SecurityProfileItem> var1);

        public Builder securityProfiles(SecurityProfileItem ... var1);

        public Builder securityProfiles(Consumer<SecurityProfileItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

