/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceAttributeType {
    INBOUND_CALLS("INBOUND_CALLS"),
    OUTBOUND_CALLS("OUTBOUND_CALLS"),
    CONTACTFLOW_LOGS("CONTACTFLOW_LOGS"),
    CONTACT_LENS("CONTACT_LENS"),
    AUTO_RESOLVE_BEST_VOICES("AUTO_RESOLVE_BEST_VOICES"),
    USE_CUSTOM_TTS_VOICES("USE_CUSTOM_TTS_VOICES"),
    EARLY_MEDIA("EARLY_MEDIA"),
    MULTI_PARTY_CONFERENCE("MULTI_PARTY_CONFERENCE"),
    HIGH_VOLUME_OUTBOUND("HIGH_VOLUME_OUTBOUND"),
    ENHANCED_CONTACT_MONITORING("ENHANCED_CONTACT_MONITORING"),
    ENHANCED_CHAT_MONITORING("ENHANCED_CHAT_MONITORING"),
    MULTI_PARTY_CHAT_CONFERENCE("MULTI_PARTY_CHAT_CONFERENCE"),
    MESSAGE_STREAMING("MESSAGE_STREAMING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceAttributeType> VALUE_MAP;
    private final String value;

    private InstanceAttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceAttributeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceAttributeType> knownValues() {
        EnumSet<InstanceAttributeType> knownValues = EnumSet.allOf(InstanceAttributeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceAttributeType.class, InstanceAttributeType::toString);
    }
}

