/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.AutoEvaluationDetails;
import software.amazon.awssdk.services.connect.model.EvaluationAcknowledgement;
import software.amazon.awssdk.services.connect.model.EvaluationContactParticipant;
import software.amazon.awssdk.services.connect.model.EvaluationScore;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationMetadata> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(EvaluationMetadata.getter(EvaluationMetadata::contactId)).setter(EvaluationMetadata.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> EVALUATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluatorArn").getter(EvaluationMetadata.getter(EvaluationMetadata::evaluatorArn)).setter(EvaluationMetadata.setter(Builder::evaluatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatorArn").build()}).build();
    private static final SdkField<String> CONTACT_AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactAgentId").getter(EvaluationMetadata.getter(EvaluationMetadata::contactAgentId)).setter(EvaluationMetadata.setter(Builder::contactAgentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactAgentId").build()}).build();
    private static final SdkField<String> CALIBRATION_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalibrationSessionId").getter(EvaluationMetadata.getter(EvaluationMetadata::calibrationSessionId)).setter(EvaluationMetadata.setter(Builder::calibrationSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalibrationSessionId").build()}).build();
    private static final SdkField<EvaluationScore> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Score").getter(EvaluationMetadata.getter(EvaluationMetadata::score)).setter(EvaluationMetadata.setter(Builder::score)).constructor(EvaluationScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final SdkField<AutoEvaluationDetails> AUTO_EVALUATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoEvaluation").getter(EvaluationMetadata.getter(EvaluationMetadata::autoEvaluation)).setter(EvaluationMetadata.setter(Builder::autoEvaluation)).constructor(AutoEvaluationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEvaluation").build()}).build();
    private static final SdkField<EvaluationAcknowledgement> ACKNOWLEDGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Acknowledgement").getter(EvaluationMetadata.getter(EvaluationMetadata::acknowledgement)).setter(EvaluationMetadata.setter(Builder::acknowledgement)).constructor(EvaluationAcknowledgement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Acknowledgement").build()}).build();
    private static final SdkField<EvaluationContactParticipant> CONTACT_PARTICIPANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContactParticipant").getter(EvaluationMetadata.getter(EvaluationMetadata::contactParticipant)).setter(EvaluationMetadata.setter(Builder::contactParticipant)).constructor(EvaluationContactParticipant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactParticipant").build()}).build();
    private static final SdkField<String> SAMPLING_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SamplingJobId").getter(EvaluationMetadata.getter(EvaluationMetadata::samplingJobId)).setter(EvaluationMetadata.setter(Builder::samplingJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingJobId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, EVALUATOR_ARN_FIELD, CONTACT_AGENT_ID_FIELD, CALIBRATION_SESSION_ID_FIELD, SCORE_FIELD, AUTO_EVALUATION_FIELD, ACKNOWLEDGEMENT_FIELD, CONTACT_PARTICIPANT_FIELD, SAMPLING_JOB_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String contactId;
    private final String evaluatorArn;
    private final String contactAgentId;
    private final String calibrationSessionId;
    private final EvaluationScore score;
    private final AutoEvaluationDetails autoEvaluation;
    private final EvaluationAcknowledgement acknowledgement;
    private final EvaluationContactParticipant contactParticipant;
    private final String samplingJobId;

    private EvaluationMetadata(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.evaluatorArn = builder.evaluatorArn;
        this.contactAgentId = builder.contactAgentId;
        this.calibrationSessionId = builder.calibrationSessionId;
        this.score = builder.score;
        this.autoEvaluation = builder.autoEvaluation;
        this.acknowledgement = builder.acknowledgement;
        this.contactParticipant = builder.contactParticipant;
        this.samplingJobId = builder.samplingJobId;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String evaluatorArn() {
        return this.evaluatorArn;
    }

    public final String contactAgentId() {
        return this.contactAgentId;
    }

    public final String calibrationSessionId() {
        return this.calibrationSessionId;
    }

    public final EvaluationScore score() {
        return this.score;
    }

    public final AutoEvaluationDetails autoEvaluation() {
        return this.autoEvaluation;
    }

    public final EvaluationAcknowledgement acknowledgement() {
        return this.acknowledgement;
    }

    public final EvaluationContactParticipant contactParticipant() {
        return this.contactParticipant;
    }

    public final String samplingJobId() {
        return this.samplingJobId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactAgentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.calibrationSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEvaluation());
        hashCode = 31 * hashCode + Objects.hashCode(this.acknowledgement());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactParticipant());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingJobId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationMetadata)) {
            return false;
        }
        EvaluationMetadata other = (EvaluationMetadata)obj;
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.evaluatorArn(), other.evaluatorArn()) && Objects.equals(this.contactAgentId(), other.contactAgentId()) && Objects.equals(this.calibrationSessionId(), other.calibrationSessionId()) && Objects.equals(this.score(), other.score()) && Objects.equals(this.autoEvaluation(), other.autoEvaluation()) && Objects.equals(this.acknowledgement(), other.acknowledgement()) && Objects.equals(this.contactParticipant(), other.contactParticipant()) && Objects.equals(this.samplingJobId(), other.samplingJobId());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationMetadata").add("ContactId", (Object)this.contactId()).add("EvaluatorArn", (Object)this.evaluatorArn()).add("ContactAgentId", (Object)this.contactAgentId()).add("CalibrationSessionId", (Object)this.calibrationSessionId()).add("Score", (Object)this.score()).add("AutoEvaluation", (Object)this.autoEvaluation()).add("Acknowledgement", (Object)this.acknowledgement()).add("ContactParticipant", (Object)this.contactParticipant()).add("SamplingJobId", (Object)this.samplingJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "EvaluatorArn": {
                return Optional.ofNullable(clazz.cast(this.evaluatorArn()));
            }
            case "ContactAgentId": {
                return Optional.ofNullable(clazz.cast(this.contactAgentId()));
            }
            case "CalibrationSessionId": {
                return Optional.ofNullable(clazz.cast(this.calibrationSessionId()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "AutoEvaluation": {
                return Optional.ofNullable(clazz.cast(this.autoEvaluation()));
            }
            case "Acknowledgement": {
                return Optional.ofNullable(clazz.cast(this.acknowledgement()));
            }
            case "ContactParticipant": {
                return Optional.ofNullable(clazz.cast(this.contactParticipant()));
            }
            case "SamplingJobId": {
                return Optional.ofNullable(clazz.cast(this.samplingJobId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("EvaluatorArn", EVALUATOR_ARN_FIELD);
        map.put("ContactAgentId", CONTACT_AGENT_ID_FIELD);
        map.put("CalibrationSessionId", CALIBRATION_SESSION_ID_FIELD);
        map.put("Score", SCORE_FIELD);
        map.put("AutoEvaluation", AUTO_EVALUATION_FIELD);
        map.put("Acknowledgement", ACKNOWLEDGEMENT_FIELD);
        map.put("ContactParticipant", CONTACT_PARTICIPANT_FIELD);
        map.put("SamplingJobId", SAMPLING_JOB_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationMetadata, T> g) {
        return obj -> g.apply((EvaluationMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contactId;
        private String evaluatorArn;
        private String contactAgentId;
        private String calibrationSessionId;
        private EvaluationScore score;
        private AutoEvaluationDetails autoEvaluation;
        private EvaluationAcknowledgement acknowledgement;
        private EvaluationContactParticipant contactParticipant;
        private String samplingJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationMetadata model) {
            this.contactId(model.contactId);
            this.evaluatorArn(model.evaluatorArn);
            this.contactAgentId(model.contactAgentId);
            this.calibrationSessionId(model.calibrationSessionId);
            this.score(model.score);
            this.autoEvaluation(model.autoEvaluation);
            this.acknowledgement(model.acknowledgement);
            this.contactParticipant(model.contactParticipant);
            this.samplingJobId(model.samplingJobId);
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getEvaluatorArn() {
            return this.evaluatorArn;
        }

        public final void setEvaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
        }

        @Override
        public final Builder evaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
            return this;
        }

        public final String getContactAgentId() {
            return this.contactAgentId;
        }

        public final void setContactAgentId(String contactAgentId) {
            this.contactAgentId = contactAgentId;
        }

        @Override
        public final Builder contactAgentId(String contactAgentId) {
            this.contactAgentId = contactAgentId;
            return this;
        }

        public final String getCalibrationSessionId() {
            return this.calibrationSessionId;
        }

        public final void setCalibrationSessionId(String calibrationSessionId) {
            this.calibrationSessionId = calibrationSessionId;
        }

        @Override
        public final Builder calibrationSessionId(String calibrationSessionId) {
            this.calibrationSessionId = calibrationSessionId;
            return this;
        }

        public final EvaluationScore.Builder getScore() {
            return this.score != null ? this.score.toBuilder() : null;
        }

        public final void setScore(EvaluationScore.BuilderImpl score) {
            this.score = score != null ? score.build() : null;
        }

        @Override
        public final Builder score(EvaluationScore score) {
            this.score = score;
            return this;
        }

        public final AutoEvaluationDetails.Builder getAutoEvaluation() {
            return this.autoEvaluation != null ? this.autoEvaluation.toBuilder() : null;
        }

        public final void setAutoEvaluation(AutoEvaluationDetails.BuilderImpl autoEvaluation) {
            this.autoEvaluation = autoEvaluation != null ? autoEvaluation.build() : null;
        }

        @Override
        public final Builder autoEvaluation(AutoEvaluationDetails autoEvaluation) {
            this.autoEvaluation = autoEvaluation;
            return this;
        }

        public final EvaluationAcknowledgement.Builder getAcknowledgement() {
            return this.acknowledgement != null ? this.acknowledgement.toBuilder() : null;
        }

        public final void setAcknowledgement(EvaluationAcknowledgement.BuilderImpl acknowledgement) {
            this.acknowledgement = acknowledgement != null ? acknowledgement.build() : null;
        }

        @Override
        public final Builder acknowledgement(EvaluationAcknowledgement acknowledgement) {
            this.acknowledgement = acknowledgement;
            return this;
        }

        public final EvaluationContactParticipant.Builder getContactParticipant() {
            return this.contactParticipant != null ? this.contactParticipant.toBuilder() : null;
        }

        public final void setContactParticipant(EvaluationContactParticipant.BuilderImpl contactParticipant) {
            this.contactParticipant = contactParticipant != null ? contactParticipant.build() : null;
        }

        @Override
        public final Builder contactParticipant(EvaluationContactParticipant contactParticipant) {
            this.contactParticipant = contactParticipant;
            return this;
        }

        public final String getSamplingJobId() {
            return this.samplingJobId;
        }

        public final void setSamplingJobId(String samplingJobId) {
            this.samplingJobId = samplingJobId;
        }

        @Override
        public final Builder samplingJobId(String samplingJobId) {
            this.samplingJobId = samplingJobId;
            return this;
        }

        public EvaluationMetadata build() {
            return new EvaluationMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationMetadata> {
        public Builder contactId(String var1);

        public Builder evaluatorArn(String var1);

        public Builder contactAgentId(String var1);

        public Builder calibrationSessionId(String var1);

        public Builder score(EvaluationScore var1);

        default public Builder score(Consumer<EvaluationScore.Builder> score) {
            return this.score((EvaluationScore)((EvaluationScore.Builder)EvaluationScore.builder().applyMutation(score)).build());
        }

        public Builder autoEvaluation(AutoEvaluationDetails var1);

        default public Builder autoEvaluation(Consumer<AutoEvaluationDetails.Builder> autoEvaluation) {
            return this.autoEvaluation((AutoEvaluationDetails)((AutoEvaluationDetails.Builder)AutoEvaluationDetails.builder().applyMutation(autoEvaluation)).build());
        }

        public Builder acknowledgement(EvaluationAcknowledgement var1);

        default public Builder acknowledgement(Consumer<EvaluationAcknowledgement.Builder> acknowledgement) {
            return this.acknowledgement((EvaluationAcknowledgement)((EvaluationAcknowledgement.Builder)EvaluationAcknowledgement.builder().applyMutation(acknowledgement)).build());
        }

        public Builder contactParticipant(EvaluationContactParticipant var1);

        default public Builder contactParticipant(Consumer<EvaluationContactParticipant.Builder> contactParticipant) {
            return this.contactParticipant((EvaluationContactParticipant)((EvaluationContactParticipant.Builder)EvaluationContactParticipant.builder().applyMutation(contactParticipant)).build());
        }

        public Builder samplingJobId(String var1);
    }
}

