/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.EvaluationTranscriptPointOfInterest;
import software.amazon.awssdk.services.connect.model.EvaluationTranscriptPointsOfInterestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationGenAIAnswerAnalysisDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationGenAIAnswerAnalysisDetails> {
    private static final SdkField<String> JUSTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Justification").getter(EvaluationGenAIAnswerAnalysisDetails.getter(EvaluationGenAIAnswerAnalysisDetails::justification)).setter(EvaluationGenAIAnswerAnalysisDetails.setter(Builder::justification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Justification").build()}).build();
    private static final SdkField<List<EvaluationTranscriptPointOfInterest>> POINTS_OF_INTEREST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PointsOfInterest").getter(EvaluationGenAIAnswerAnalysisDetails.getter(EvaluationGenAIAnswerAnalysisDetails::pointsOfInterest)).setter(EvaluationGenAIAnswerAnalysisDetails.setter(Builder::pointsOfInterest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PointsOfInterest").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationTranscriptPointOfInterest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JUSTIFICATION_FIELD, POINTS_OF_INTEREST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationGenAIAnswerAnalysisDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String justification;
    private final List<EvaluationTranscriptPointOfInterest> pointsOfInterest;

    private EvaluationGenAIAnswerAnalysisDetails(BuilderImpl builder) {
        this.justification = builder.justification;
        this.pointsOfInterest = builder.pointsOfInterest;
    }

    public final String justification() {
        return this.justification;
    }

    public final boolean hasPointsOfInterest() {
        return this.pointsOfInterest != null && !(this.pointsOfInterest instanceof SdkAutoConstructList);
    }

    public final List<EvaluationTranscriptPointOfInterest> pointsOfInterest() {
        return this.pointsOfInterest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.justification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPointsOfInterest() ? this.pointsOfInterest() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationGenAIAnswerAnalysisDetails)) {
            return false;
        }
        EvaluationGenAIAnswerAnalysisDetails other = (EvaluationGenAIAnswerAnalysisDetails)obj;
        return Objects.equals(this.justification(), other.justification()) && this.hasPointsOfInterest() == other.hasPointsOfInterest() && Objects.equals(this.pointsOfInterest(), other.pointsOfInterest());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationGenAIAnswerAnalysisDetails").add("Justification", (Object)this.justification()).add("PointsOfInterest", this.hasPointsOfInterest() ? this.pointsOfInterest() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Justification": {
                return Optional.ofNullable(clazz.cast(this.justification()));
            }
            case "PointsOfInterest": {
                return Optional.ofNullable(clazz.cast(this.pointsOfInterest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Justification", JUSTIFICATION_FIELD);
        map.put("PointsOfInterest", POINTS_OF_INTEREST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationGenAIAnswerAnalysisDetails, T> g) {
        return obj -> g.apply((EvaluationGenAIAnswerAnalysisDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String justification;
        private List<EvaluationTranscriptPointOfInterest> pointsOfInterest = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationGenAIAnswerAnalysisDetails model) {
            this.justification(model.justification);
            this.pointsOfInterest(model.pointsOfInterest);
        }

        public final String getJustification() {
            return this.justification;
        }

        public final void setJustification(String justification) {
            this.justification = justification;
        }

        @Override
        public final Builder justification(String justification) {
            this.justification = justification;
            return this;
        }

        public final List<EvaluationTranscriptPointOfInterest.Builder> getPointsOfInterest() {
            List<EvaluationTranscriptPointOfInterest.Builder> result = EvaluationTranscriptPointsOfInterestCopier.copyToBuilder(this.pointsOfInterest);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPointsOfInterest(Collection<EvaluationTranscriptPointOfInterest.BuilderImpl> pointsOfInterest) {
            this.pointsOfInterest = EvaluationTranscriptPointsOfInterestCopier.copyFromBuilder(pointsOfInterest);
        }

        @Override
        public final Builder pointsOfInterest(Collection<EvaluationTranscriptPointOfInterest> pointsOfInterest) {
            this.pointsOfInterest = EvaluationTranscriptPointsOfInterestCopier.copy(pointsOfInterest);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pointsOfInterest(EvaluationTranscriptPointOfInterest ... pointsOfInterest) {
            this.pointsOfInterest(Arrays.asList(pointsOfInterest));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pointsOfInterest(Consumer<EvaluationTranscriptPointOfInterest.Builder> ... pointsOfInterest) {
            this.pointsOfInterest(Stream.of(pointsOfInterest).map(c -> (EvaluationTranscriptPointOfInterest)((EvaluationTranscriptPointOfInterest.Builder)EvaluationTranscriptPointOfInterest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EvaluationGenAIAnswerAnalysisDetails build() {
            return new EvaluationGenAIAnswerAnalysisDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationGenAIAnswerAnalysisDetails> {
        public Builder justification(String var1);

        public Builder pointsOfInterest(Collection<EvaluationTranscriptPointOfInterest> var1);

        public Builder pointsOfInterest(EvaluationTranscriptPointOfInterest ... var1);

        public Builder pointsOfInterest(Consumer<EvaluationTranscriptPointOfInterest.Builder> ... var1);
    }
}

