/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EvaluationFormLanguageCode {
    DE_DE("de-DE"),
    EN_US("en-US"),
    ES_ES("es-ES"),
    FR_FR("fr-FR"),
    IT_IT("it-IT"),
    PT_BR("pt-BR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EvaluationFormLanguageCode> VALUE_MAP;
    private final String value;

    private EvaluationFormLanguageCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EvaluationFormLanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EvaluationFormLanguageCode> knownValues() {
        EnumSet<EvaluationFormLanguageCode> knownValues = EnumSet.allOf(EvaluationFormLanguageCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EvaluationFormLanguageCode.class, EvaluationFormLanguageCode::toString);
    }
}

