/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.EvaluationFormAutoEvaluationConfiguration;
import software.amazon.awssdk.services.connect.model.EvaluationFormItem;
import software.amazon.awssdk.services.connect.model.EvaluationFormItemsListCopier;
import software.amazon.awssdk.services.connect.model.EvaluationFormLanguageConfiguration;
import software.amazon.awssdk.services.connect.model.EvaluationFormScoringStrategy;
import software.amazon.awssdk.services.connect.model.EvaluationFormTargetConfiguration;
import software.amazon.awssdk.services.connect.model.EvaluationFormVersionStatus;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationForm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationForm> {
    private static final SdkField<String> EVALUATION_FORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationFormId").getter(EvaluationForm.getter(EvaluationForm::evaluationFormId)).setter(EvaluationForm.setter(Builder::evaluationFormId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormId").build()}).build();
    private static final SdkField<Integer> EVALUATION_FORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EvaluationFormVersion").getter(EvaluationForm.getter(EvaluationForm::evaluationFormVersion)).setter(EvaluationForm.setter(Builder::evaluationFormVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormVersion").build()}).build();
    private static final SdkField<Boolean> LOCKED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Locked").getter(EvaluationForm.getter(EvaluationForm::locked)).setter(EvaluationForm.setter(Builder::locked)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locked").build()}).build();
    private static final SdkField<String> EVALUATION_FORM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationFormArn").getter(EvaluationForm.getter(EvaluationForm::evaluationFormArn)).setter(EvaluationForm.setter(Builder::evaluationFormArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormArn").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(EvaluationForm.getter(EvaluationForm::title)).setter(EvaluationForm.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(EvaluationForm.getter(EvaluationForm::description)).setter(EvaluationForm.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EvaluationForm.getter(EvaluationForm::statusAsString)).setter(EvaluationForm.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<EvaluationFormItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(EvaluationForm.getter(EvaluationForm::items)).setter(EvaluationForm.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationFormItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EvaluationFormScoringStrategy> SCORING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScoringStrategy").getter(EvaluationForm.getter(EvaluationForm::scoringStrategy)).setter(EvaluationForm.setter(Builder::scoringStrategy)).constructor(EvaluationFormScoringStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoringStrategy").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(EvaluationForm.getter(EvaluationForm::createdTime)).setter(EvaluationForm.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(EvaluationForm.getter(EvaluationForm::createdBy)).setter(EvaluationForm.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(EvaluationForm.getter(EvaluationForm::lastModifiedTime)).setter(EvaluationForm.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedBy").getter(EvaluationForm.getter(EvaluationForm::lastModifiedBy)).setter(EvaluationForm.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<EvaluationFormAutoEvaluationConfiguration> AUTO_EVALUATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoEvaluationConfiguration").getter(EvaluationForm.getter(EvaluationForm::autoEvaluationConfiguration)).setter(EvaluationForm.setter(Builder::autoEvaluationConfiguration)).constructor(EvaluationFormAutoEvaluationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEvaluationConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(EvaluationForm.getter(EvaluationForm::tags)).setter(EvaluationForm.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<EvaluationFormTargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetConfiguration").getter(EvaluationForm.getter(EvaluationForm::targetConfiguration)).setter(EvaluationForm.setter(Builder::targetConfiguration)).constructor(EvaluationFormTargetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration").build()}).build();
    private static final SdkField<EvaluationFormLanguageConfiguration> LANGUAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LanguageConfiguration").getter(EvaluationForm.getter(EvaluationForm::languageConfiguration)).setter(EvaluationForm.setter(Builder::languageConfiguration)).constructor(EvaluationFormLanguageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_FORM_ID_FIELD, EVALUATION_FORM_VERSION_FIELD, LOCKED_FIELD, EVALUATION_FORM_ARN_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, ITEMS_FIELD, SCORING_STRATEGY_FIELD, CREATED_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, AUTO_EVALUATION_CONFIGURATION_FIELD, TAGS_FIELD, TARGET_CONFIGURATION_FIELD, LANGUAGE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationForm.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String evaluationFormId;
    private final Integer evaluationFormVersion;
    private final Boolean locked;
    private final String evaluationFormArn;
    private final String title;
    private final String description;
    private final String status;
    private final List<EvaluationFormItem> items;
    private final EvaluationFormScoringStrategy scoringStrategy;
    private final Instant createdTime;
    private final String createdBy;
    private final Instant lastModifiedTime;
    private final String lastModifiedBy;
    private final EvaluationFormAutoEvaluationConfiguration autoEvaluationConfiguration;
    private final Map<String, String> tags;
    private final EvaluationFormTargetConfiguration targetConfiguration;
    private final EvaluationFormLanguageConfiguration languageConfiguration;

    private EvaluationForm(BuilderImpl builder) {
        this.evaluationFormId = builder.evaluationFormId;
        this.evaluationFormVersion = builder.evaluationFormVersion;
        this.locked = builder.locked;
        this.evaluationFormArn = builder.evaluationFormArn;
        this.title = builder.title;
        this.description = builder.description;
        this.status = builder.status;
        this.items = builder.items;
        this.scoringStrategy = builder.scoringStrategy;
        this.createdTime = builder.createdTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.autoEvaluationConfiguration = builder.autoEvaluationConfiguration;
        this.tags = builder.tags;
        this.targetConfiguration = builder.targetConfiguration;
        this.languageConfiguration = builder.languageConfiguration;
    }

    public final String evaluationFormId() {
        return this.evaluationFormId;
    }

    public final Integer evaluationFormVersion() {
        return this.evaluationFormVersion;
    }

    public final Boolean locked() {
        return this.locked;
    }

    public final String evaluationFormArn() {
        return this.evaluationFormArn;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final EvaluationFormVersionStatus status() {
        return EvaluationFormVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<EvaluationFormItem> items() {
        return this.items;
    }

    public final EvaluationFormScoringStrategy scoringStrategy() {
        return this.scoringStrategy;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final EvaluationFormAutoEvaluationConfiguration autoEvaluationConfiguration() {
        return this.autoEvaluationConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final EvaluationFormTargetConfiguration targetConfiguration() {
        return this.targetConfiguration;
    }

    public final EvaluationFormLanguageConfiguration languageConfiguration() {
        return this.languageConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.locked());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scoringStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEvaluationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationForm)) {
            return false;
        }
        EvaluationForm other = (EvaluationForm)obj;
        return Objects.equals(this.evaluationFormId(), other.evaluationFormId()) && Objects.equals(this.evaluationFormVersion(), other.evaluationFormVersion()) && Objects.equals(this.locked(), other.locked()) && Objects.equals(this.evaluationFormArn(), other.evaluationFormArn()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.scoringStrategy(), other.scoringStrategy()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.autoEvaluationConfiguration(), other.autoEvaluationConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.targetConfiguration(), other.targetConfiguration()) && Objects.equals(this.languageConfiguration(), other.languageConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationForm").add("EvaluationFormId", (Object)this.evaluationFormId()).add("EvaluationFormVersion", (Object)this.evaluationFormVersion()).add("Locked", (Object)this.locked()).add("EvaluationFormArn", (Object)this.evaluationFormArn()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("Items", this.hasItems() ? this.items() : null).add("ScoringStrategy", (Object)this.scoringStrategy()).add("CreatedTime", (Object)this.createdTime()).add("CreatedBy", (Object)this.createdBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("AutoEvaluationConfiguration", (Object)this.autoEvaluationConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).add("TargetConfiguration", (Object)this.targetConfiguration()).add("LanguageConfiguration", (Object)this.languageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationFormId": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormId()));
            }
            case "EvaluationFormVersion": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormVersion()));
            }
            case "Locked": {
                return Optional.ofNullable(clazz.cast(this.locked()));
            }
            case "EvaluationFormArn": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormArn()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "ScoringStrategy": {
                return Optional.ofNullable(clazz.cast(this.scoringStrategy()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "AutoEvaluationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoEvaluationConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TargetConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetConfiguration()));
            }
            case "LanguageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.languageConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EvaluationFormId", EVALUATION_FORM_ID_FIELD);
        map.put("EvaluationFormVersion", EVALUATION_FORM_VERSION_FIELD);
        map.put("Locked", LOCKED_FIELD);
        map.put("EvaluationFormArn", EVALUATION_FORM_ARN_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Items", ITEMS_FIELD);
        map.put("ScoringStrategy", SCORING_STRATEGY_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("AutoEvaluationConfiguration", AUTO_EVALUATION_CONFIGURATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TargetConfiguration", TARGET_CONFIGURATION_FIELD);
        map.put("LanguageConfiguration", LANGUAGE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationForm, T> g) {
        return obj -> g.apply((EvaluationForm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String evaluationFormId;
        private Integer evaluationFormVersion;
        private Boolean locked;
        private String evaluationFormArn;
        private String title;
        private String description;
        private String status;
        private List<EvaluationFormItem> items = DefaultSdkAutoConstructList.getInstance();
        private EvaluationFormScoringStrategy scoringStrategy;
        private Instant createdTime;
        private String createdBy;
        private Instant lastModifiedTime;
        private String lastModifiedBy;
        private EvaluationFormAutoEvaluationConfiguration autoEvaluationConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private EvaluationFormTargetConfiguration targetConfiguration;
        private EvaluationFormLanguageConfiguration languageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationForm model) {
            this.evaluationFormId(model.evaluationFormId);
            this.evaluationFormVersion(model.evaluationFormVersion);
            this.locked(model.locked);
            this.evaluationFormArn(model.evaluationFormArn);
            this.title(model.title);
            this.description(model.description);
            this.status(model.status);
            this.items(model.items);
            this.scoringStrategy(model.scoringStrategy);
            this.createdTime(model.createdTime);
            this.createdBy(model.createdBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedBy(model.lastModifiedBy);
            this.autoEvaluationConfiguration(model.autoEvaluationConfiguration);
            this.tags(model.tags);
            this.targetConfiguration(model.targetConfiguration);
            this.languageConfiguration(model.languageConfiguration);
        }

        public final String getEvaluationFormId() {
            return this.evaluationFormId;
        }

        public final void setEvaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
        }

        @Override
        public final Builder evaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
            return this;
        }

        public final Integer getEvaluationFormVersion() {
            return this.evaluationFormVersion;
        }

        public final void setEvaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
        }

        @Override
        public final Builder evaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
            return this;
        }

        public final Boolean getLocked() {
            return this.locked;
        }

        public final void setLocked(Boolean locked) {
            this.locked = locked;
        }

        @Override
        public final Builder locked(Boolean locked) {
            this.locked = locked;
            return this;
        }

        public final String getEvaluationFormArn() {
            return this.evaluationFormArn;
        }

        public final void setEvaluationFormArn(String evaluationFormArn) {
            this.evaluationFormArn = evaluationFormArn;
        }

        @Override
        public final Builder evaluationFormArn(String evaluationFormArn) {
            this.evaluationFormArn = evaluationFormArn;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationFormVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<EvaluationFormItem.Builder> getItems() {
            List<EvaluationFormItem.Builder> result = EvaluationFormItemsListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<EvaluationFormItem.BuilderImpl> items) {
            this.items = EvaluationFormItemsListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<EvaluationFormItem> items) {
            this.items = EvaluationFormItemsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(EvaluationFormItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<EvaluationFormItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (EvaluationFormItem)((EvaluationFormItem.Builder)EvaluationFormItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EvaluationFormScoringStrategy.Builder getScoringStrategy() {
            return this.scoringStrategy != null ? this.scoringStrategy.toBuilder() : null;
        }

        public final void setScoringStrategy(EvaluationFormScoringStrategy.BuilderImpl scoringStrategy) {
            this.scoringStrategy = scoringStrategy != null ? scoringStrategy.build() : null;
        }

        @Override
        public final Builder scoringStrategy(EvaluationFormScoringStrategy scoringStrategy) {
            this.scoringStrategy = scoringStrategy;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final EvaluationFormAutoEvaluationConfiguration.Builder getAutoEvaluationConfiguration() {
            return this.autoEvaluationConfiguration != null ? this.autoEvaluationConfiguration.toBuilder() : null;
        }

        public final void setAutoEvaluationConfiguration(EvaluationFormAutoEvaluationConfiguration.BuilderImpl autoEvaluationConfiguration) {
            this.autoEvaluationConfiguration = autoEvaluationConfiguration != null ? autoEvaluationConfiguration.build() : null;
        }

        @Override
        public final Builder autoEvaluationConfiguration(EvaluationFormAutoEvaluationConfiguration autoEvaluationConfiguration) {
            this.autoEvaluationConfiguration = autoEvaluationConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final EvaluationFormTargetConfiguration.Builder getTargetConfiguration() {
            return this.targetConfiguration != null ? this.targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(EvaluationFormTargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(EvaluationFormTargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final EvaluationFormLanguageConfiguration.Builder getLanguageConfiguration() {
            return this.languageConfiguration != null ? this.languageConfiguration.toBuilder() : null;
        }

        public final void setLanguageConfiguration(EvaluationFormLanguageConfiguration.BuilderImpl languageConfiguration) {
            this.languageConfiguration = languageConfiguration != null ? languageConfiguration.build() : null;
        }

        @Override
        public final Builder languageConfiguration(EvaluationFormLanguageConfiguration languageConfiguration) {
            this.languageConfiguration = languageConfiguration;
            return this;
        }

        public EvaluationForm build() {
            return new EvaluationForm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationForm> {
        public Builder evaluationFormId(String var1);

        public Builder evaluationFormVersion(Integer var1);

        public Builder locked(Boolean var1);

        public Builder evaluationFormArn(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(EvaluationFormVersionStatus var1);

        public Builder items(Collection<EvaluationFormItem> var1);

        public Builder items(EvaluationFormItem ... var1);

        public Builder items(Consumer<EvaluationFormItem.Builder> ... var1);

        public Builder scoringStrategy(EvaluationFormScoringStrategy var1);

        default public Builder scoringStrategy(Consumer<EvaluationFormScoringStrategy.Builder> scoringStrategy) {
            return this.scoringStrategy((EvaluationFormScoringStrategy)((EvaluationFormScoringStrategy.Builder)EvaluationFormScoringStrategy.builder().applyMutation(scoringStrategy)).build());
        }

        public Builder createdTime(Instant var1);

        public Builder createdBy(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedBy(String var1);

        public Builder autoEvaluationConfiguration(EvaluationFormAutoEvaluationConfiguration var1);

        default public Builder autoEvaluationConfiguration(Consumer<EvaluationFormAutoEvaluationConfiguration.Builder> autoEvaluationConfiguration) {
            return this.autoEvaluationConfiguration((EvaluationFormAutoEvaluationConfiguration)((EvaluationFormAutoEvaluationConfiguration.Builder)EvaluationFormAutoEvaluationConfiguration.builder().applyMutation(autoEvaluationConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder targetConfiguration(EvaluationFormTargetConfiguration var1);

        default public Builder targetConfiguration(Consumer<EvaluationFormTargetConfiguration.Builder> targetConfiguration) {
            return this.targetConfiguration((EvaluationFormTargetConfiguration)((EvaluationFormTargetConfiguration.Builder)EvaluationFormTargetConfiguration.builder().applyMutation(targetConfiguration)).build());
        }

        public Builder languageConfiguration(EvaluationFormLanguageConfiguration var1);

        default public Builder languageConfiguration(Consumer<EvaluationFormLanguageConfiguration.Builder> languageConfiguration) {
            return this.languageConfiguration((EvaluationFormLanguageConfiguration)((EvaluationFormLanguageConfiguration.Builder)EvaluationFormLanguageConfiguration.builder().applyMutation(languageConfiguration)).build());
        }
    }
}

