/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.DataTableEvaluatedValue;
import software.amazon.awssdk.services.connect.model.DataTableEvaluatedValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateDataTableValuesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, EvaluateDataTableValuesResponse> {
    private static final SdkField<List<DataTableEvaluatedValue>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(EvaluateDataTableValuesResponse.getter(EvaluateDataTableValuesResponse::values)).setter(EvaluateDataTableValuesResponse.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataTableEvaluatedValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(EvaluateDataTableValuesResponse.getter(EvaluateDataTableValuesResponse::nextToken)).setter(EvaluateDataTableValuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluateDataTableValuesResponse.memberNameToFieldInitializer();
    private final List<DataTableEvaluatedValue> values;
    private final String nextToken;

    private EvaluateDataTableValuesResponse(BuilderImpl builder) {
        super(builder);
        this.values = builder.values;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<DataTableEvaluatedValue> values() {
        return this.values;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateDataTableValuesResponse)) {
            return false;
        }
        EvaluateDataTableValuesResponse other = (EvaluateDataTableValuesResponse)((Object)obj);
        return this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluateDataTableValuesResponse").add("Values", this.hasValues() ? this.values() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Values", VALUES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluateDataTableValuesResponse, T> g) {
        return obj -> g.apply((EvaluateDataTableValuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<DataTableEvaluatedValue> values = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateDataTableValuesResponse model) {
            super(model);
            this.values(model.values);
            this.nextToken(model.nextToken);
        }

        public final List<DataTableEvaluatedValue.Builder> getValues() {
            List<DataTableEvaluatedValue.Builder> result = DataTableEvaluatedValueListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<DataTableEvaluatedValue.BuilderImpl> values) {
            this.values = DataTableEvaluatedValueListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<DataTableEvaluatedValue> values) {
            this.values = DataTableEvaluatedValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(DataTableEvaluatedValue ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<DataTableEvaluatedValue.Builder> ... values) {
            this.values(Stream.of(values).map(c -> (DataTableEvaluatedValue)((DataTableEvaluatedValue.Builder)DataTableEvaluatedValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public EvaluateDataTableValuesResponse build() {
            return new EvaluateDataTableValuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EvaluateDataTableValuesResponse> {
        public Builder values(Collection<DataTableEvaluatedValue> var1);

        public Builder values(DataTableEvaluatedValue ... var1);

        public Builder values(Consumer<DataTableEvaluatedValue.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

