/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AttributeNameListCopier;
import software.amazon.awssdk.services.connect.model.PrimaryValue;
import software.amazon.awssdk.services.connect.model.PrimaryValuesSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataTableValueEvaluationSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataTableValueEvaluationSet> {
    private static final SdkField<List<PrimaryValue>> PRIMARY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrimaryValues").getter(DataTableValueEvaluationSet.getter(DataTableValueEvaluationSet::primaryValues)).setter(DataTableValueEvaluationSet.setter(Builder::primaryValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrimaryValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeNames").getter(DataTableValueEvaluationSet.getter(DataTableValueEvaluationSet::attributeNames)).setter(DataTableValueEvaluationSet.setter(Builder::attributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_VALUES_FIELD, ATTRIBUTE_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataTableValueEvaluationSet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<PrimaryValue> primaryValues;
    private final List<String> attributeNames;

    private DataTableValueEvaluationSet(BuilderImpl builder) {
        this.primaryValues = builder.primaryValues;
        this.attributeNames = builder.attributeNames;
    }

    public final boolean hasPrimaryValues() {
        return this.primaryValues != null && !(this.primaryValues instanceof SdkAutoConstructList);
    }

    public final List<PrimaryValue> primaryValues() {
        return this.primaryValues;
    }

    public final boolean hasAttributeNames() {
        return this.attributeNames != null && !(this.attributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> attributeNames() {
        return this.attributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrimaryValues() ? this.primaryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeNames() ? this.attributeNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTableValueEvaluationSet)) {
            return false;
        }
        DataTableValueEvaluationSet other = (DataTableValueEvaluationSet)obj;
        return this.hasPrimaryValues() == other.hasPrimaryValues() && Objects.equals(this.primaryValues(), other.primaryValues()) && this.hasAttributeNames() == other.hasAttributeNames() && Objects.equals(this.attributeNames(), other.attributeNames());
    }

    public final String toString() {
        return ToString.builder((String)"DataTableValueEvaluationSet").add("PrimaryValues", this.hasPrimaryValues() ? this.primaryValues() : null).add("AttributeNames", this.hasAttributeNames() ? this.attributeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryValues": {
                return Optional.ofNullable(clazz.cast(this.primaryValues()));
            }
            case "AttributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PrimaryValues", PRIMARY_VALUES_FIELD);
        map.put("AttributeNames", ATTRIBUTE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataTableValueEvaluationSet, T> g) {
        return obj -> g.apply((DataTableValueEvaluationSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PrimaryValue> primaryValues = DefaultSdkAutoConstructList.getInstance();
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataTableValueEvaluationSet model) {
            this.primaryValues(model.primaryValues);
            this.attributeNames(model.attributeNames);
        }

        public final List<PrimaryValue.Builder> getPrimaryValues() {
            List<PrimaryValue.Builder> result = PrimaryValuesSetCopier.copyToBuilder(this.primaryValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryValues(Collection<PrimaryValue.BuilderImpl> primaryValues) {
            this.primaryValues = PrimaryValuesSetCopier.copyFromBuilder(primaryValues);
        }

        @Override
        public final Builder primaryValues(Collection<PrimaryValue> primaryValues) {
            this.primaryValues = PrimaryValuesSetCopier.copy(primaryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(PrimaryValue ... primaryValues) {
            this.primaryValues(Arrays.asList(primaryValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(Consumer<PrimaryValue.Builder> ... primaryValues) {
            this.primaryValues(Stream.of(primaryValues).map(c -> (PrimaryValue)((PrimaryValue.Builder)PrimaryValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (this.attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public DataTableValueEvaluationSet build() {
            return new DataTableValueEvaluationSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataTableValueEvaluationSet> {
        public Builder primaryValues(Collection<PrimaryValue> var1);

        public Builder primaryValues(PrimaryValue ... var1);

        public Builder primaryValues(Consumer<PrimaryValue.Builder> ... var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);
    }
}

