/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.DataTableAttributeValueType;
import software.amazon.awssdk.services.connect.model.PrimaryValue;
import software.amazon.awssdk.services.connect.model.PrimaryValuesSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataTableEvaluatedValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataTableEvaluatedValue> {
    private static final SdkField<String> RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordId").getter(DataTableEvaluatedValue.getter(DataTableEvaluatedValue::recordId)).setter(DataTableEvaluatedValue.setter(Builder::recordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordId").build()}).build();
    private static final SdkField<List<PrimaryValue>> PRIMARY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrimaryValues").getter(DataTableEvaluatedValue.getter(DataTableEvaluatedValue::primaryValues)).setter(DataTableEvaluatedValue.setter(Builder::primaryValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrimaryValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(DataTableEvaluatedValue.getter(DataTableEvaluatedValue::attributeName)).setter(DataTableEvaluatedValue.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueType").getter(DataTableEvaluatedValue.getter(DataTableEvaluatedValue::valueTypeAsString)).setter(DataTableEvaluatedValue.setter(Builder::valueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()}).build();
    private static final SdkField<Boolean> FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Found").getter(DataTableEvaluatedValue.getter(DataTableEvaluatedValue::found)).setter(DataTableEvaluatedValue.setter(Builder::found)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Found").build()}).build();
    private static final SdkField<Boolean> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Error").getter(DataTableEvaluatedValue.getter(DataTableEvaluatedValue::error)).setter(DataTableEvaluatedValue.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<String> EVALUATED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluatedValue").getter(DataTableEvaluatedValue.getter(DataTableEvaluatedValue::evaluatedValue)).setter(DataTableEvaluatedValue.setter(Builder::evaluatedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatedValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_ID_FIELD, PRIMARY_VALUES_FIELD, ATTRIBUTE_NAME_FIELD, VALUE_TYPE_FIELD, FOUND_FIELD, ERROR_FIELD, EVALUATED_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataTableEvaluatedValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String recordId;
    private final List<PrimaryValue> primaryValues;
    private final String attributeName;
    private final String valueType;
    private final Boolean found;
    private final Boolean error;
    private final String evaluatedValue;

    private DataTableEvaluatedValue(BuilderImpl builder) {
        this.recordId = builder.recordId;
        this.primaryValues = builder.primaryValues;
        this.attributeName = builder.attributeName;
        this.valueType = builder.valueType;
        this.found = builder.found;
        this.error = builder.error;
        this.evaluatedValue = builder.evaluatedValue;
    }

    public final String recordId() {
        return this.recordId;
    }

    public final boolean hasPrimaryValues() {
        return this.primaryValues != null && !(this.primaryValues instanceof SdkAutoConstructList);
    }

    public final List<PrimaryValue> primaryValues() {
        return this.primaryValues;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final DataTableAttributeValueType valueType() {
        return DataTableAttributeValueType.fromValue(this.valueType);
    }

    public final String valueTypeAsString() {
        return this.valueType;
    }

    public final Boolean found() {
        return this.found;
    }

    public final Boolean error() {
        return this.error;
    }

    public final String evaluatedValue() {
        return this.evaluatedValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrimaryValues() ? this.primaryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.found());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatedValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTableEvaluatedValue)) {
            return false;
        }
        DataTableEvaluatedValue other = (DataTableEvaluatedValue)obj;
        return Objects.equals(this.recordId(), other.recordId()) && this.hasPrimaryValues() == other.hasPrimaryValues() && Objects.equals(this.primaryValues(), other.primaryValues()) && Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.valueTypeAsString(), other.valueTypeAsString()) && Objects.equals(this.found(), other.found()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.evaluatedValue(), other.evaluatedValue());
    }

    public final String toString() {
        return ToString.builder((String)"DataTableEvaluatedValue").add("RecordId", (Object)this.recordId()).add("PrimaryValues", this.hasPrimaryValues() ? this.primaryValues() : null).add("AttributeName", (Object)this.attributeName()).add("ValueType", (Object)this.valueTypeAsString()).add("Found", (Object)this.found()).add("Error", (Object)this.error()).add("EvaluatedValue", (Object)this.evaluatedValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordId": {
                return Optional.ofNullable(clazz.cast(this.recordId()));
            }
            case "PrimaryValues": {
                return Optional.ofNullable(clazz.cast(this.primaryValues()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "ValueType": {
                return Optional.ofNullable(clazz.cast(this.valueTypeAsString()));
            }
            case "Found": {
                return Optional.ofNullable(clazz.cast(this.found()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "EvaluatedValue": {
                return Optional.ofNullable(clazz.cast(this.evaluatedValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RecordId", RECORD_ID_FIELD);
        map.put("PrimaryValues", PRIMARY_VALUES_FIELD);
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("ValueType", VALUE_TYPE_FIELD);
        map.put("Found", FOUND_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("EvaluatedValue", EVALUATED_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataTableEvaluatedValue, T> g) {
        return obj -> g.apply((DataTableEvaluatedValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recordId;
        private List<PrimaryValue> primaryValues = DefaultSdkAutoConstructList.getInstance();
        private String attributeName;
        private String valueType;
        private Boolean found;
        private Boolean error;
        private String evaluatedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTableEvaluatedValue model) {
            this.recordId(model.recordId);
            this.primaryValues(model.primaryValues);
            this.attributeName(model.attributeName);
            this.valueType(model.valueType);
            this.found(model.found);
            this.error(model.error);
            this.evaluatedValue(model.evaluatedValue);
        }

        public final String getRecordId() {
            return this.recordId;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final List<PrimaryValue.Builder> getPrimaryValues() {
            List<PrimaryValue.Builder> result = PrimaryValuesSetCopier.copyToBuilder(this.primaryValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryValues(Collection<PrimaryValue.BuilderImpl> primaryValues) {
            this.primaryValues = PrimaryValuesSetCopier.copyFromBuilder(primaryValues);
        }

        @Override
        public final Builder primaryValues(Collection<PrimaryValue> primaryValues) {
            this.primaryValues = PrimaryValuesSetCopier.copy(primaryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(PrimaryValue ... primaryValues) {
            this.primaryValues(Arrays.asList(primaryValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(Consumer<PrimaryValue.Builder> ... primaryValues) {
            this.primaryValues(Stream.of(primaryValues).map(c -> (PrimaryValue)((PrimaryValue.Builder)PrimaryValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getValueType() {
            return this.valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(DataTableAttributeValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final Boolean getFound() {
            return this.found;
        }

        public final void setFound(Boolean found) {
            this.found = found;
        }

        @Override
        public final Builder found(Boolean found) {
            this.found = found;
            return this;
        }

        public final Boolean getError() {
            return this.error;
        }

        public final void setError(Boolean error) {
            this.error = error;
        }

        @Override
        public final Builder error(Boolean error) {
            this.error = error;
            return this;
        }

        public final String getEvaluatedValue() {
            return this.evaluatedValue;
        }

        public final void setEvaluatedValue(String evaluatedValue) {
            this.evaluatedValue = evaluatedValue;
        }

        @Override
        public final Builder evaluatedValue(String evaluatedValue) {
            this.evaluatedValue = evaluatedValue;
            return this;
        }

        public DataTableEvaluatedValue build() {
            return new DataTableEvaluatedValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataTableEvaluatedValue> {
        public Builder recordId(String var1);

        public Builder primaryValues(Collection<PrimaryValue> var1);

        public Builder primaryValues(PrimaryValue ... var1);

        public Builder primaryValues(Consumer<PrimaryValue.Builder> ... var1);

        public Builder attributeName(String var1);

        public Builder valueType(String var1);

        public Builder valueType(DataTableAttributeValueType var1);

        public Builder found(Boolean var1);

        public Builder error(Boolean var1);

        public Builder evaluatedValue(String var1);
    }
}

