/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.SegmentAttributeValue;
import software.amazon.awssdk.services.connect.model.SegmentAttributeValueMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactSearchSummarySegmentAttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactSearchSummarySegmentAttributeValue> {
    private static final SdkField<String> VALUE_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueString").getter(ContactSearchSummarySegmentAttributeValue.getter(ContactSearchSummarySegmentAttributeValue::valueString)).setter(ContactSearchSummarySegmentAttributeValue.setter(Builder::valueString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueString").build()}).build();
    private static final SdkField<Map<String, SegmentAttributeValue>> VALUE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ValueMap").getter(ContactSearchSummarySegmentAttributeValue.getter(ContactSearchSummarySegmentAttributeValue::valueMap)).setter(ContactSearchSummarySegmentAttributeValue.setter(Builder::valueMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_STRING_FIELD, VALUE_MAP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContactSearchSummarySegmentAttributeValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String valueString;
    private final Map<String, SegmentAttributeValue> valueMap;

    private ContactSearchSummarySegmentAttributeValue(BuilderImpl builder) {
        this.valueString = builder.valueString;
        this.valueMap = builder.valueMap;
    }

    public final String valueString() {
        return this.valueString;
    }

    public final boolean hasValueMap() {
        return this.valueMap != null && !(this.valueMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, SegmentAttributeValue> valueMap() {
        return this.valueMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.valueString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValueMap() ? this.valueMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactSearchSummarySegmentAttributeValue)) {
            return false;
        }
        ContactSearchSummarySegmentAttributeValue other = (ContactSearchSummarySegmentAttributeValue)obj;
        return Objects.equals(this.valueString(), other.valueString()) && this.hasValueMap() == other.hasValueMap() && Objects.equals(this.valueMap(), other.valueMap());
    }

    public final String toString() {
        return ToString.builder((String)"ContactSearchSummarySegmentAttributeValue").add("ValueString", (Object)this.valueString()).add("ValueMap", this.hasValueMap() ? this.valueMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ValueString": {
                return Optional.ofNullable(clazz.cast(this.valueString()));
            }
            case "ValueMap": {
                return Optional.ofNullable(clazz.cast(this.valueMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ValueString", VALUE_STRING_FIELD);
        map.put("ValueMap", VALUE_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactSearchSummarySegmentAttributeValue, T> g) {
        return obj -> g.apply((ContactSearchSummarySegmentAttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String valueString;
        private Map<String, SegmentAttributeValue> valueMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContactSearchSummarySegmentAttributeValue model) {
            this.valueString(model.valueString);
            this.valueMap(model.valueMap);
        }

        public final String getValueString() {
            return this.valueString;
        }

        public final void setValueString(String valueString) {
            this.valueString = valueString;
        }

        @Override
        public final Builder valueString(String valueString) {
            this.valueString = valueString;
            return this;
        }

        public final Map<String, SegmentAttributeValue.Builder> getValueMap() {
            Map<String, SegmentAttributeValue.Builder> result = SegmentAttributeValueMapCopier.copyToBuilder(this.valueMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setValueMap(Map<String, SegmentAttributeValue.BuilderImpl> valueMap) {
            this.valueMap = SegmentAttributeValueMapCopier.copyFromBuilder(valueMap);
        }

        @Override
        public final Builder valueMap(Map<String, SegmentAttributeValue> valueMap) {
            this.valueMap = SegmentAttributeValueMapCopier.copy(valueMap);
            return this;
        }

        public ContactSearchSummarySegmentAttributeValue build() {
            return new ContactSearchSummarySegmentAttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactSearchSummarySegmentAttributeValue> {
        public Builder valueString(String var1);

        public Builder valueMap(Map<String, SegmentAttributeValue> var1);
    }
}

