/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.services.connect.model.ContactInitiationMethod;
import software.amazon.awssdk.services.connect.model.ContactSearchSummaryAgentInfo;
import software.amazon.awssdk.services.connect.model.ContactSearchSummaryQueueInfo;
import software.amazon.awssdk.services.connect.model.ContactSearchSummarySegmentAttributeValue;
import software.amazon.awssdk.services.connect.model.ContactSearchSummarySegmentAttributesCopier;
import software.amazon.awssdk.services.connect.model.GlobalResiliencyMetadata;
import software.amazon.awssdk.services.connect.model.RoutingCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactSearchSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactSearchSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ContactSearchSummary.getter(ContactSearchSummary::arn)).setter(ContactSearchSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ContactSearchSummary.getter(ContactSearchSummary::id)).setter(ContactSearchSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitialContactId").getter(ContactSearchSummary.getter(ContactSearchSummary::initialContactId)).setter(ContactSearchSummary.setter(Builder::initialContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialContactId").build()}).build();
    private static final SdkField<String> PREVIOUS_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousContactId").getter(ContactSearchSummary.getter(ContactSearchSummary::previousContactId)).setter(ContactSearchSummary.setter(Builder::previousContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousContactId").build()}).build();
    private static final SdkField<String> INITIATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitiationMethod").getter(ContactSearchSummary.getter(ContactSearchSummary::initiationMethodAsString)).setter(ContactSearchSummary.setter(Builder::initiationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationMethod").build()}).build();
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Channel").getter(ContactSearchSummary.getter(ContactSearchSummary::channelAsString)).setter(ContactSearchSummary.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()}).build();
    private static final SdkField<ContactSearchSummaryQueueInfo> QUEUE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueueInfo").getter(ContactSearchSummary.getter(ContactSearchSummary::queueInfo)).setter(ContactSearchSummary.setter(Builder::queueInfo)).constructor(ContactSearchSummaryQueueInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueInfo").build()}).build();
    private static final SdkField<ContactSearchSummaryAgentInfo> AGENT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AgentInfo").getter(ContactSearchSummary.getter(ContactSearchSummary::agentInfo)).setter(ContactSearchSummary.setter(Builder::agentInfo)).constructor(ContactSearchSummaryAgentInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentInfo").build()}).build();
    private static final SdkField<Instant> INITIATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InitiationTimestamp").getter(ContactSearchSummary.getter(ContactSearchSummary::initiationTimestamp)).setter(ContactSearchSummary.setter(Builder::initiationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationTimestamp").build()}).build();
    private static final SdkField<Instant> DISCONNECT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DisconnectTimestamp").getter(ContactSearchSummary.getter(ContactSearchSummary::disconnectTimestamp)).setter(ContactSearchSummary.setter(Builder::disconnectTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectTimestamp").build()}).build();
    private static final SdkField<Instant> SCHEDULED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduledTimestamp").getter(ContactSearchSummary.getter(ContactSearchSummary::scheduledTimestamp)).setter(ContactSearchSummary.setter(Builder::scheduledTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTimestamp").build()}).build();
    private static final SdkField<Map<String, ContactSearchSummarySegmentAttributeValue>> SEGMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SegmentAttributes").getter(ContactSearchSummary.getter(ContactSearchSummary::segmentAttributes)).setter(ContactSearchSummary.setter(Builder::segmentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactSearchSummarySegmentAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ContactSearchSummary.getter(ContactSearchSummary::name)).setter(ContactSearchSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<RoutingCriteria> ROUTING_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoutingCriteria").getter(ContactSearchSummary.getter(ContactSearchSummary::routingCriteria)).setter(ContactSearchSummary.setter(Builder::routingCriteria)).constructor(RoutingCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingCriteria").build()}).build();
    private static final SdkField<GlobalResiliencyMetadata> GLOBAL_RESILIENCY_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GlobalResiliencyMetadata").getter(ContactSearchSummary.getter(ContactSearchSummary::globalResiliencyMetadata)).setter(ContactSearchSummary.setter(Builder::globalResiliencyMetadata)).constructor(GlobalResiliencyMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalResiliencyMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, INITIAL_CONTACT_ID_FIELD, PREVIOUS_CONTACT_ID_FIELD, INITIATION_METHOD_FIELD, CHANNEL_FIELD, QUEUE_INFO_FIELD, AGENT_INFO_FIELD, INITIATION_TIMESTAMP_FIELD, DISCONNECT_TIMESTAMP_FIELD, SCHEDULED_TIMESTAMP_FIELD, SEGMENT_ATTRIBUTES_FIELD, NAME_FIELD, ROUTING_CRITERIA_FIELD, GLOBAL_RESILIENCY_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContactSearchSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String initialContactId;
    private final String previousContactId;
    private final String initiationMethod;
    private final String channel;
    private final ContactSearchSummaryQueueInfo queueInfo;
    private final ContactSearchSummaryAgentInfo agentInfo;
    private final Instant initiationTimestamp;
    private final Instant disconnectTimestamp;
    private final Instant scheduledTimestamp;
    private final Map<String, ContactSearchSummarySegmentAttributeValue> segmentAttributes;
    private final String name;
    private final RoutingCriteria routingCriteria;
    private final GlobalResiliencyMetadata globalResiliencyMetadata;

    private ContactSearchSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.initialContactId = builder.initialContactId;
        this.previousContactId = builder.previousContactId;
        this.initiationMethod = builder.initiationMethod;
        this.channel = builder.channel;
        this.queueInfo = builder.queueInfo;
        this.agentInfo = builder.agentInfo;
        this.initiationTimestamp = builder.initiationTimestamp;
        this.disconnectTimestamp = builder.disconnectTimestamp;
        this.scheduledTimestamp = builder.scheduledTimestamp;
        this.segmentAttributes = builder.segmentAttributes;
        this.name = builder.name;
        this.routingCriteria = builder.routingCriteria;
        this.globalResiliencyMetadata = builder.globalResiliencyMetadata;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String initialContactId() {
        return this.initialContactId;
    }

    public final String previousContactId() {
        return this.previousContactId;
    }

    public final ContactInitiationMethod initiationMethod() {
        return ContactInitiationMethod.fromValue(this.initiationMethod);
    }

    public final String initiationMethodAsString() {
        return this.initiationMethod;
    }

    public final Channel channel() {
        return Channel.fromValue(this.channel);
    }

    public final String channelAsString() {
        return this.channel;
    }

    public final ContactSearchSummaryQueueInfo queueInfo() {
        return this.queueInfo;
    }

    public final ContactSearchSummaryAgentInfo agentInfo() {
        return this.agentInfo;
    }

    public final Instant initiationTimestamp() {
        return this.initiationTimestamp;
    }

    public final Instant disconnectTimestamp() {
        return this.disconnectTimestamp;
    }

    public final Instant scheduledTimestamp() {
        return this.scheduledTimestamp;
    }

    public final boolean hasSegmentAttributes() {
        return this.segmentAttributes != null && !(this.segmentAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, ContactSearchSummarySegmentAttributeValue> segmentAttributes() {
        return this.segmentAttributes;
    }

    public final String name() {
        return this.name;
    }

    public final RoutingCriteria routingCriteria() {
        return this.routingCriteria;
    }

    public final GlobalResiliencyMetadata globalResiliencyMetadata() {
        return this.globalResiliencyMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentAttributes() ? this.segmentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalResiliencyMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactSearchSummary)) {
            return false;
        }
        ContactSearchSummary other = (ContactSearchSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.initialContactId(), other.initialContactId()) && Objects.equals(this.previousContactId(), other.previousContactId()) && Objects.equals(this.initiationMethodAsString(), other.initiationMethodAsString()) && Objects.equals(this.channelAsString(), other.channelAsString()) && Objects.equals(this.queueInfo(), other.queueInfo()) && Objects.equals(this.agentInfo(), other.agentInfo()) && Objects.equals(this.initiationTimestamp(), other.initiationTimestamp()) && Objects.equals(this.disconnectTimestamp(), other.disconnectTimestamp()) && Objects.equals(this.scheduledTimestamp(), other.scheduledTimestamp()) && this.hasSegmentAttributes() == other.hasSegmentAttributes() && Objects.equals(this.segmentAttributes(), other.segmentAttributes()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.routingCriteria(), other.routingCriteria()) && Objects.equals(this.globalResiliencyMetadata(), other.globalResiliencyMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"ContactSearchSummary").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("InitialContactId", (Object)this.initialContactId()).add("PreviousContactId", (Object)this.previousContactId()).add("InitiationMethod", (Object)this.initiationMethodAsString()).add("Channel", (Object)this.channelAsString()).add("QueueInfo", (Object)this.queueInfo()).add("AgentInfo", (Object)this.agentInfo()).add("InitiationTimestamp", (Object)this.initiationTimestamp()).add("DisconnectTimestamp", (Object)this.disconnectTimestamp()).add("ScheduledTimestamp", (Object)this.scheduledTimestamp()).add("SegmentAttributes", (Object)(this.segmentAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("RoutingCriteria", (Object)this.routingCriteria()).add("GlobalResiliencyMetadata", (Object)this.globalResiliencyMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InitialContactId": {
                return Optional.ofNullable(clazz.cast(this.initialContactId()));
            }
            case "PreviousContactId": {
                return Optional.ofNullable(clazz.cast(this.previousContactId()));
            }
            case "InitiationMethod": {
                return Optional.ofNullable(clazz.cast(this.initiationMethodAsString()));
            }
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
            case "QueueInfo": {
                return Optional.ofNullable(clazz.cast(this.queueInfo()));
            }
            case "AgentInfo": {
                return Optional.ofNullable(clazz.cast(this.agentInfo()));
            }
            case "InitiationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.initiationTimestamp()));
            }
            case "DisconnectTimestamp": {
                return Optional.ofNullable(clazz.cast(this.disconnectTimestamp()));
            }
            case "ScheduledTimestamp": {
                return Optional.ofNullable(clazz.cast(this.scheduledTimestamp()));
            }
            case "SegmentAttributes": {
                return Optional.ofNullable(clazz.cast(this.segmentAttributes()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RoutingCriteria": {
                return Optional.ofNullable(clazz.cast(this.routingCriteria()));
            }
            case "GlobalResiliencyMetadata": {
                return Optional.ofNullable(clazz.cast(this.globalResiliencyMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("InitialContactId", INITIAL_CONTACT_ID_FIELD);
        map.put("PreviousContactId", PREVIOUS_CONTACT_ID_FIELD);
        map.put("InitiationMethod", INITIATION_METHOD_FIELD);
        map.put("Channel", CHANNEL_FIELD);
        map.put("QueueInfo", QUEUE_INFO_FIELD);
        map.put("AgentInfo", AGENT_INFO_FIELD);
        map.put("InitiationTimestamp", INITIATION_TIMESTAMP_FIELD);
        map.put("DisconnectTimestamp", DISCONNECT_TIMESTAMP_FIELD);
        map.put("ScheduledTimestamp", SCHEDULED_TIMESTAMP_FIELD);
        map.put("SegmentAttributes", SEGMENT_ATTRIBUTES_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RoutingCriteria", ROUTING_CRITERIA_FIELD);
        map.put("GlobalResiliencyMetadata", GLOBAL_RESILIENCY_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactSearchSummary, T> g) {
        return obj -> g.apply((ContactSearchSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String initialContactId;
        private String previousContactId;
        private String initiationMethod;
        private String channel;
        private ContactSearchSummaryQueueInfo queueInfo;
        private ContactSearchSummaryAgentInfo agentInfo;
        private Instant initiationTimestamp;
        private Instant disconnectTimestamp;
        private Instant scheduledTimestamp;
        private Map<String, ContactSearchSummarySegmentAttributeValue> segmentAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String name;
        private RoutingCriteria routingCriteria;
        private GlobalResiliencyMetadata globalResiliencyMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactSearchSummary model) {
            this.arn(model.arn);
            this.id(model.id);
            this.initialContactId(model.initialContactId);
            this.previousContactId(model.previousContactId);
            this.initiationMethod(model.initiationMethod);
            this.channel(model.channel);
            this.queueInfo(model.queueInfo);
            this.agentInfo(model.agentInfo);
            this.initiationTimestamp(model.initiationTimestamp);
            this.disconnectTimestamp(model.disconnectTimestamp);
            this.scheduledTimestamp(model.scheduledTimestamp);
            this.segmentAttributes(model.segmentAttributes);
            this.name(model.name);
            this.routingCriteria(model.routingCriteria);
            this.globalResiliencyMetadata(model.globalResiliencyMetadata);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getInitialContactId() {
            return this.initialContactId;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final String getPreviousContactId() {
            return this.previousContactId;
        }

        public final void setPreviousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
        }

        @Override
        public final Builder previousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
            return this;
        }

        public final String getInitiationMethod() {
            return this.initiationMethod;
        }

        public final void setInitiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
        }

        @Override
        public final Builder initiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
            return this;
        }

        @Override
        public final Builder initiationMethod(ContactInitiationMethod initiationMethod) {
            this.initiationMethod(initiationMethod == null ? null : initiationMethod.toString());
            return this;
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final ContactSearchSummaryQueueInfo.Builder getQueueInfo() {
            return this.queueInfo != null ? this.queueInfo.toBuilder() : null;
        }

        public final void setQueueInfo(ContactSearchSummaryQueueInfo.BuilderImpl queueInfo) {
            this.queueInfo = queueInfo != null ? queueInfo.build() : null;
        }

        @Override
        public final Builder queueInfo(ContactSearchSummaryQueueInfo queueInfo) {
            this.queueInfo = queueInfo;
            return this;
        }

        public final ContactSearchSummaryAgentInfo.Builder getAgentInfo() {
            return this.agentInfo != null ? this.agentInfo.toBuilder() : null;
        }

        public final void setAgentInfo(ContactSearchSummaryAgentInfo.BuilderImpl agentInfo) {
            this.agentInfo = agentInfo != null ? agentInfo.build() : null;
        }

        @Override
        public final Builder agentInfo(ContactSearchSummaryAgentInfo agentInfo) {
            this.agentInfo = agentInfo;
            return this;
        }

        public final Instant getInitiationTimestamp() {
            return this.initiationTimestamp;
        }

        public final void setInitiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
        }

        @Override
        public final Builder initiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
            return this;
        }

        public final Instant getDisconnectTimestamp() {
            return this.disconnectTimestamp;
        }

        public final void setDisconnectTimestamp(Instant disconnectTimestamp) {
            this.disconnectTimestamp = disconnectTimestamp;
        }

        @Override
        public final Builder disconnectTimestamp(Instant disconnectTimestamp) {
            this.disconnectTimestamp = disconnectTimestamp;
            return this;
        }

        public final Instant getScheduledTimestamp() {
            return this.scheduledTimestamp;
        }

        public final void setScheduledTimestamp(Instant scheduledTimestamp) {
            this.scheduledTimestamp = scheduledTimestamp;
        }

        @Override
        public final Builder scheduledTimestamp(Instant scheduledTimestamp) {
            this.scheduledTimestamp = scheduledTimestamp;
            return this;
        }

        public final Map<String, ContactSearchSummarySegmentAttributeValue.Builder> getSegmentAttributes() {
            Map<String, ContactSearchSummarySegmentAttributeValue.Builder> result = ContactSearchSummarySegmentAttributesCopier.copyToBuilder(this.segmentAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSegmentAttributes(Map<String, ContactSearchSummarySegmentAttributeValue.BuilderImpl> segmentAttributes) {
            this.segmentAttributes = ContactSearchSummarySegmentAttributesCopier.copyFromBuilder(segmentAttributes);
        }

        @Override
        public final Builder segmentAttributes(Map<String, ContactSearchSummarySegmentAttributeValue> segmentAttributes) {
            this.segmentAttributes = ContactSearchSummarySegmentAttributesCopier.copy(segmentAttributes);
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RoutingCriteria.Builder getRoutingCriteria() {
            return this.routingCriteria != null ? this.routingCriteria.toBuilder() : null;
        }

        public final void setRoutingCriteria(RoutingCriteria.BuilderImpl routingCriteria) {
            this.routingCriteria = routingCriteria != null ? routingCriteria.build() : null;
        }

        @Override
        public final Builder routingCriteria(RoutingCriteria routingCriteria) {
            this.routingCriteria = routingCriteria;
            return this;
        }

        public final GlobalResiliencyMetadata.Builder getGlobalResiliencyMetadata() {
            return this.globalResiliencyMetadata != null ? this.globalResiliencyMetadata.toBuilder() : null;
        }

        public final void setGlobalResiliencyMetadata(GlobalResiliencyMetadata.BuilderImpl globalResiliencyMetadata) {
            this.globalResiliencyMetadata = globalResiliencyMetadata != null ? globalResiliencyMetadata.build() : null;
        }

        @Override
        public final Builder globalResiliencyMetadata(GlobalResiliencyMetadata globalResiliencyMetadata) {
            this.globalResiliencyMetadata = globalResiliencyMetadata;
            return this;
        }

        public ContactSearchSummary build() {
            return new ContactSearchSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactSearchSummary> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder initialContactId(String var1);

        public Builder previousContactId(String var1);

        public Builder initiationMethod(String var1);

        public Builder initiationMethod(ContactInitiationMethod var1);

        public Builder channel(String var1);

        public Builder channel(Channel var1);

        public Builder queueInfo(ContactSearchSummaryQueueInfo var1);

        default public Builder queueInfo(Consumer<ContactSearchSummaryQueueInfo.Builder> queueInfo) {
            return this.queueInfo((ContactSearchSummaryQueueInfo)((ContactSearchSummaryQueueInfo.Builder)ContactSearchSummaryQueueInfo.builder().applyMutation(queueInfo)).build());
        }

        public Builder agentInfo(ContactSearchSummaryAgentInfo var1);

        default public Builder agentInfo(Consumer<ContactSearchSummaryAgentInfo.Builder> agentInfo) {
            return this.agentInfo((ContactSearchSummaryAgentInfo)((ContactSearchSummaryAgentInfo.Builder)ContactSearchSummaryAgentInfo.builder().applyMutation(agentInfo)).build());
        }

        public Builder initiationTimestamp(Instant var1);

        public Builder disconnectTimestamp(Instant var1);

        public Builder scheduledTimestamp(Instant var1);

        public Builder segmentAttributes(Map<String, ContactSearchSummarySegmentAttributeValue> var1);

        public Builder name(String var1);

        public Builder routingCriteria(RoutingCriteria var1);

        default public Builder routingCriteria(Consumer<RoutingCriteria.Builder> routingCriteria) {
            return this.routingCriteria((RoutingCriteria)((RoutingCriteria.Builder)RoutingCriteria.builder().applyMutation(routingCriteria)).build());
        }

        public Builder globalResiliencyMetadata(GlobalResiliencyMetadata var1);

        default public Builder globalResiliencyMetadata(Consumer<GlobalResiliencyMetadata.Builder> globalResiliencyMetadata) {
            return this.globalResiliencyMetadata((GlobalResiliencyMetadata)((GlobalResiliencyMetadata.Builder)GlobalResiliencyMetadata.builder().applyMutation(globalResiliencyMetadata)).build());
        }
    }
}

