/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.EntityType;
import software.amazon.awssdk.services.connect.model.SecurityProfileItem;
import software.amazon.awssdk.services.connect.model.SecurityProfilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateSecurityProfilesRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, AssociateSecurityProfilesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(AssociateSecurityProfilesRequest.getter(AssociateSecurityProfilesRequest::instanceId)).setter(AssociateSecurityProfilesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<List<SecurityProfileItem>> SECURITY_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityProfiles").getter(AssociateSecurityProfilesRequest.getter(AssociateSecurityProfilesRequest::securityProfiles)).setter(AssociateSecurityProfilesRequest.setter(Builder::securityProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityProfileItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityType").getter(AssociateSecurityProfilesRequest.getter(AssociateSecurityProfilesRequest::entityTypeAsString)).setter(AssociateSecurityProfilesRequest.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()}).build();
    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityArn").getter(AssociateSecurityProfilesRequest.getter(AssociateSecurityProfilesRequest::entityArn)).setter(AssociateSecurityProfilesRequest.setter(Builder::entityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, SECURITY_PROFILES_FIELD, ENTITY_TYPE_FIELD, ENTITY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateSecurityProfilesRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final List<SecurityProfileItem> securityProfiles;
    private final String entityType;
    private final String entityArn;

    private AssociateSecurityProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.securityProfiles = builder.securityProfiles;
        this.entityType = builder.entityType;
        this.entityArn = builder.entityArn;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final boolean hasSecurityProfiles() {
        return this.securityProfiles != null && !(this.securityProfiles instanceof SdkAutoConstructList);
    }

    public final List<SecurityProfileItem> securityProfiles() {
        return this.securityProfiles;
    }

    public final EntityType entityType() {
        return EntityType.fromValue(this.entityType);
    }

    public final String entityTypeAsString() {
        return this.entityType;
    }

    public final String entityArn() {
        return this.entityArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityProfiles() ? this.securityProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSecurityProfilesRequest)) {
            return false;
        }
        AssociateSecurityProfilesRequest other = (AssociateSecurityProfilesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && this.hasSecurityProfiles() == other.hasSecurityProfiles() && Objects.equals(this.securityProfiles(), other.securityProfiles()) && Objects.equals(this.entityTypeAsString(), other.entityTypeAsString()) && Objects.equals(this.entityArn(), other.entityArn());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateSecurityProfilesRequest").add("InstanceId", (Object)this.instanceId()).add("SecurityProfiles", this.hasSecurityProfiles() ? this.securityProfiles() : null).add("EntityType", (Object)this.entityTypeAsString()).add("EntityArn", (Object)this.entityArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "SecurityProfiles": {
                return Optional.ofNullable(clazz.cast(this.securityProfiles()));
            }
            case "EntityType": {
                return Optional.ofNullable(clazz.cast(this.entityTypeAsString()));
            }
            case "EntityArn": {
                return Optional.ofNullable(clazz.cast(this.entityArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("SecurityProfiles", SECURITY_PROFILES_FIELD);
        map.put("EntityType", ENTITY_TYPE_FIELD);
        map.put("EntityArn", ENTITY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateSecurityProfilesRequest, T> g) {
        return obj -> g.apply((AssociateSecurityProfilesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private List<SecurityProfileItem> securityProfiles = DefaultSdkAutoConstructList.getInstance();
        private String entityType;
        private String entityArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSecurityProfilesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.securityProfiles(model.securityProfiles);
            this.entityType(model.entityType);
            this.entityArn(model.entityArn);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final List<SecurityProfileItem.Builder> getSecurityProfiles() {
            List<SecurityProfileItem.Builder> result = SecurityProfilesCopier.copyToBuilder(this.securityProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityProfiles(Collection<SecurityProfileItem.BuilderImpl> securityProfiles) {
            this.securityProfiles = SecurityProfilesCopier.copyFromBuilder(securityProfiles);
        }

        @Override
        public final Builder securityProfiles(Collection<SecurityProfileItem> securityProfiles) {
            this.securityProfiles = SecurityProfilesCopier.copy(securityProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfiles(SecurityProfileItem ... securityProfiles) {
            this.securityProfiles(Arrays.asList(securityProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfiles(Consumer<SecurityProfileItem.Builder> ... securityProfiles) {
            this.securityProfiles(Stream.of(securityProfiles).map(c -> (SecurityProfileItem)((SecurityProfileItem.Builder)SecurityProfileItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(EntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final String getEntityArn() {
            return this.entityArn;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSecurityProfilesRequest build() {
            return new AssociateSecurityProfilesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateSecurityProfilesRequest> {
        public Builder instanceId(String var1);

        public Builder securityProfiles(Collection<SecurityProfileItem> var1);

        public Builder securityProfiles(SecurityProfileItem ... var1);

        public Builder securityProfiles(Consumer<SecurityProfileItem.Builder> ... var1);

        public Builder entityType(String var1);

        public Builder entityType(EntityType var1);

        public Builder entityArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

