/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.SearchViewsRequest;
import software.amazon.awssdk.services.connect.model.SearchViewsResponse;
import software.amazon.awssdk.services.connect.model.View;

public class SearchViewsPublisher
implements SdkPublisher<SearchViewsResponse> {
    private final ConnectAsyncClient client;
    private final SearchViewsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchViewsPublisher(ConnectAsyncClient client, SearchViewsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchViewsPublisher(ConnectAsyncClient client, SearchViewsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchViewsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchViewsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<View> views() {
        Function<SearchViewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.views() != null) {
                return response.views().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchViewsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchViewsResponseFetcher
    implements AsyncPageFetcher<SearchViewsResponse> {
        private SearchViewsResponseFetcher() {
        }

        public boolean hasNextPage(SearchViewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchViewsResponse> nextPage(SearchViewsResponse previousPage) {
            if (previousPage == null) {
                return SearchViewsPublisher.this.client.searchViews(SearchViewsPublisher.this.firstRequest);
            }
            return SearchViewsPublisher.this.client.searchViews((SearchViewsRequest)((Object)SearchViewsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

