/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.AgentStatusIdentifier;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.services.connect.model.QueueReference;
import software.amazon.awssdk.services.connect.model.RoutingProfileReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Dimensions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Dimensions> {
    private static final SdkField<QueueReference> QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Queue").getter(Dimensions.getter(Dimensions::queue)).setter(Dimensions.setter(Builder::queue)).constructor(QueueReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queue").build()}).build();
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Channel").getter(Dimensions.getter(Dimensions::channelAsString)).setter(Dimensions.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()}).build();
    private static final SdkField<RoutingProfileReference> ROUTING_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoutingProfile").getter(Dimensions.getter(Dimensions::routingProfile)).setter(Dimensions.setter(Builder::routingProfile)).constructor(RoutingProfileReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfile").build()}).build();
    private static final SdkField<String> ROUTING_STEP_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingStepExpression").getter(Dimensions.getter(Dimensions::routingStepExpression)).setter(Dimensions.setter(Builder::routingStepExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingStepExpression").build()}).build();
    private static final SdkField<AgentStatusIdentifier> AGENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AgentStatus").getter(Dimensions.getter(Dimensions::agentStatus)).setter(Dimensions.setter(Builder::agentStatus)).constructor(AgentStatusIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentStatus").build()}).build();
    private static final SdkField<String> SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subtype").getter(Dimensions.getter(Dimensions::subtype)).setter(Dimensions.setter(Builder::subtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subtype").build()}).build();
    private static final SdkField<String> VALIDATION_TEST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationTestType").getter(Dimensions.getter(Dimensions::validationTestType)).setter(Dimensions.setter(Builder::validationTestType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationTestType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_FIELD, CHANNEL_FIELD, ROUTING_PROFILE_FIELD, ROUTING_STEP_EXPRESSION_FIELD, AGENT_STATUS_FIELD, SUBTYPE_FIELD, VALIDATION_TEST_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Dimensions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final QueueReference queue;
    private final String channel;
    private final RoutingProfileReference routingProfile;
    private final String routingStepExpression;
    private final AgentStatusIdentifier agentStatus;
    private final String subtype;
    private final String validationTestType;

    private Dimensions(BuilderImpl builder) {
        this.queue = builder.queue;
        this.channel = builder.channel;
        this.routingProfile = builder.routingProfile;
        this.routingStepExpression = builder.routingStepExpression;
        this.agentStatus = builder.agentStatus;
        this.subtype = builder.subtype;
        this.validationTestType = builder.validationTestType;
    }

    public final QueueReference queue() {
        return this.queue;
    }

    public final Channel channel() {
        return Channel.fromValue(this.channel);
    }

    public final String channelAsString() {
        return this.channel;
    }

    public final RoutingProfileReference routingProfile() {
        return this.routingProfile;
    }

    public final String routingStepExpression() {
        return this.routingStepExpression;
    }

    public final AgentStatusIdentifier agentStatus() {
        return this.agentStatus;
    }

    public final String subtype() {
        return this.subtype;
    }

    public final String validationTestType() {
        return this.validationTestType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queue());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingStepExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtype());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationTestType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dimensions)) {
            return false;
        }
        Dimensions other = (Dimensions)obj;
        return Objects.equals(this.queue(), other.queue()) && Objects.equals(this.channelAsString(), other.channelAsString()) && Objects.equals(this.routingProfile(), other.routingProfile()) && Objects.equals(this.routingStepExpression(), other.routingStepExpression()) && Objects.equals(this.agentStatus(), other.agentStatus()) && Objects.equals(this.subtype(), other.subtype()) && Objects.equals(this.validationTestType(), other.validationTestType());
    }

    public final String toString() {
        return ToString.builder((String)"Dimensions").add("Queue", (Object)this.queue()).add("Channel", (Object)this.channelAsString()).add("RoutingProfile", (Object)this.routingProfile()).add("RoutingStepExpression", (Object)this.routingStepExpression()).add("AgentStatus", (Object)this.agentStatus()).add("Subtype", (Object)this.subtype()).add("ValidationTestType", (Object)this.validationTestType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Queue": {
                return Optional.ofNullable(clazz.cast(this.queue()));
            }
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
            case "RoutingProfile": {
                return Optional.ofNullable(clazz.cast(this.routingProfile()));
            }
            case "RoutingStepExpression": {
                return Optional.ofNullable(clazz.cast(this.routingStepExpression()));
            }
            case "AgentStatus": {
                return Optional.ofNullable(clazz.cast(this.agentStatus()));
            }
            case "Subtype": {
                return Optional.ofNullable(clazz.cast(this.subtype()));
            }
            case "ValidationTestType": {
                return Optional.ofNullable(clazz.cast(this.validationTestType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Queue", QUEUE_FIELD);
        map.put("Channel", CHANNEL_FIELD);
        map.put("RoutingProfile", ROUTING_PROFILE_FIELD);
        map.put("RoutingStepExpression", ROUTING_STEP_EXPRESSION_FIELD);
        map.put("AgentStatus", AGENT_STATUS_FIELD);
        map.put("Subtype", SUBTYPE_FIELD);
        map.put("ValidationTestType", VALIDATION_TEST_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Dimensions, T> g) {
        return obj -> g.apply((Dimensions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private QueueReference queue;
        private String channel;
        private RoutingProfileReference routingProfile;
        private String routingStepExpression;
        private AgentStatusIdentifier agentStatus;
        private String subtype;
        private String validationTestType;

        private BuilderImpl() {
        }

        private BuilderImpl(Dimensions model) {
            this.queue(model.queue);
            this.channel(model.channel);
            this.routingProfile(model.routingProfile);
            this.routingStepExpression(model.routingStepExpression);
            this.agentStatus(model.agentStatus);
            this.subtype(model.subtype);
            this.validationTestType(model.validationTestType);
        }

        public final QueueReference.Builder getQueue() {
            return this.queue != null ? this.queue.toBuilder() : null;
        }

        public final void setQueue(QueueReference.BuilderImpl queue) {
            this.queue = queue != null ? queue.build() : null;
        }

        @Override
        public final Builder queue(QueueReference queue) {
            this.queue = queue;
            return this;
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final RoutingProfileReference.Builder getRoutingProfile() {
            return this.routingProfile != null ? this.routingProfile.toBuilder() : null;
        }

        public final void setRoutingProfile(RoutingProfileReference.BuilderImpl routingProfile) {
            this.routingProfile = routingProfile != null ? routingProfile.build() : null;
        }

        @Override
        public final Builder routingProfile(RoutingProfileReference routingProfile) {
            this.routingProfile = routingProfile;
            return this;
        }

        public final String getRoutingStepExpression() {
            return this.routingStepExpression;
        }

        public final void setRoutingStepExpression(String routingStepExpression) {
            this.routingStepExpression = routingStepExpression;
        }

        @Override
        public final Builder routingStepExpression(String routingStepExpression) {
            this.routingStepExpression = routingStepExpression;
            return this;
        }

        public final AgentStatusIdentifier.Builder getAgentStatus() {
            return this.agentStatus != null ? this.agentStatus.toBuilder() : null;
        }

        public final void setAgentStatus(AgentStatusIdentifier.BuilderImpl agentStatus) {
            this.agentStatus = agentStatus != null ? agentStatus.build() : null;
        }

        @Override
        public final Builder agentStatus(AgentStatusIdentifier agentStatus) {
            this.agentStatus = agentStatus;
            return this;
        }

        public final String getSubtype() {
            return this.subtype;
        }

        public final void setSubtype(String subtype) {
            this.subtype = subtype;
        }

        @Override
        public final Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        public final String getValidationTestType() {
            return this.validationTestType;
        }

        public final void setValidationTestType(String validationTestType) {
            this.validationTestType = validationTestType;
        }

        @Override
        public final Builder validationTestType(String validationTestType) {
            this.validationTestType = validationTestType;
            return this;
        }

        public Dimensions build() {
            return new Dimensions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Dimensions> {
        public Builder queue(QueueReference var1);

        default public Builder queue(Consumer<QueueReference.Builder> queue) {
            return this.queue((QueueReference)((QueueReference.Builder)QueueReference.builder().applyMutation(queue)).build());
        }

        public Builder channel(String var1);

        public Builder channel(Channel var1);

        public Builder routingProfile(RoutingProfileReference var1);

        default public Builder routingProfile(Consumer<RoutingProfileReference.Builder> routingProfile) {
            return this.routingProfile((RoutingProfileReference)((RoutingProfileReference.Builder)RoutingProfileReference.builder().applyMutation(routingProfile)).build());
        }

        public Builder routingStepExpression(String var1);

        public Builder agentStatus(AgentStatusIdentifier var1);

        default public Builder agentStatus(Consumer<AgentStatusIdentifier.Builder> agentStatus) {
            return this.agentStatus((AgentStatusIdentifier)((AgentStatusIdentifier.Builder)AgentStatusIdentifier.builder().applyMutation(agentStatus)).build());
        }

        public Builder subtype(String var1);

        public Builder validationTestType(String var1);
    }
}

