/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.BatchCreateDataTableValueFailureResult;
import software.amazon.awssdk.services.connect.model.BatchCreateDataTableValueFailureResultListCopier;
import software.amazon.awssdk.services.connect.model.BatchCreateDataTableValueSuccessResult;
import software.amazon.awssdk.services.connect.model.BatchCreateDataTableValueSuccessResultListCopier;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateDataTableValueResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, BatchCreateDataTableValueResponse> {
    private static final SdkField<List<BatchCreateDataTableValueSuccessResult>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Successful").getter(BatchCreateDataTableValueResponse.getter(BatchCreateDataTableValueResponse::successful)).setter(BatchCreateDataTableValueResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchCreateDataTableValueSuccessResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchCreateDataTableValueFailureResult>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Failed").getter(BatchCreateDataTableValueResponse.getter(BatchCreateDataTableValueResponse::failed)).setter(BatchCreateDataTableValueResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchCreateDataTableValueFailureResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD, FAILED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchCreateDataTableValueResponse.memberNameToFieldInitializer();
    private final List<BatchCreateDataTableValueSuccessResult> successful;
    private final List<BatchCreateDataTableValueFailureResult> failed;

    private BatchCreateDataTableValueResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<BatchCreateDataTableValueSuccessResult> successful() {
        return this.successful;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<BatchCreateDataTableValueFailureResult> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateDataTableValueResponse)) {
            return false;
        }
        BatchCreateDataTableValueResponse other = (BatchCreateDataTableValueResponse)((Object)obj);
        return this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful()) && this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateDataTableValueResponse").add("Successful", this.hasSuccessful() ? this.successful() : null).add("Failed", this.hasFailed() ? this.failed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Successful", SUCCESSFUL_FIELD);
        map.put("Failed", FAILED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateDataTableValueResponse, T> g) {
        return obj -> g.apply((BatchCreateDataTableValueResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<BatchCreateDataTableValueSuccessResult> successful = DefaultSdkAutoConstructList.getInstance();
        private List<BatchCreateDataTableValueFailureResult> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateDataTableValueResponse model) {
            super(model);
            this.successful(model.successful);
            this.failed(model.failed);
        }

        public final List<BatchCreateDataTableValueSuccessResult.Builder> getSuccessful() {
            List<BatchCreateDataTableValueSuccessResult.Builder> result = BatchCreateDataTableValueSuccessResultListCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<BatchCreateDataTableValueSuccessResult.BuilderImpl> successful) {
            this.successful = BatchCreateDataTableValueSuccessResultListCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<BatchCreateDataTableValueSuccessResult> successful) {
            this.successful = BatchCreateDataTableValueSuccessResultListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(BatchCreateDataTableValueSuccessResult ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<BatchCreateDataTableValueSuccessResult.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (BatchCreateDataTableValueSuccessResult)((BatchCreateDataTableValueSuccessResult.Builder)BatchCreateDataTableValueSuccessResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchCreateDataTableValueFailureResult.Builder> getFailed() {
            List<BatchCreateDataTableValueFailureResult.Builder> result = BatchCreateDataTableValueFailureResultListCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchCreateDataTableValueFailureResult.BuilderImpl> failed) {
            this.failed = BatchCreateDataTableValueFailureResultListCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchCreateDataTableValueFailureResult> failed) {
            this.failed = BatchCreateDataTableValueFailureResultListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchCreateDataTableValueFailureResult ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchCreateDataTableValueFailureResult.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (BatchCreateDataTableValueFailureResult)((BatchCreateDataTableValueFailureResult.Builder)BatchCreateDataTableValueFailureResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchCreateDataTableValueResponse build() {
            return new BatchCreateDataTableValueResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateDataTableValueResponse> {
        public Builder successful(Collection<BatchCreateDataTableValueSuccessResult> var1);

        public Builder successful(BatchCreateDataTableValueSuccessResult ... var1);

        public Builder successful(Consumer<BatchCreateDataTableValueSuccessResult.Builder> ... var1);

        public Builder failed(Collection<BatchCreateDataTableValueFailureResult> var1);

        public Builder failed(BatchCreateDataTableValueFailureResult ... var1);

        public Builder failed(Consumer<BatchCreateDataTableValueFailureResult.Builder> ... var1);
    }
}

