/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.SearchContactsTimeRange;
import software.amazon.awssdk.services.connect.model.SearchCriteria;
import software.amazon.awssdk.services.connect.model.Sort;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchContactsRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, SearchContactsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(SearchContactsRequest.getter(SearchContactsRequest::instanceId)).setter(SearchContactsRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<SearchContactsTimeRange> TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeRange").getter(SearchContactsRequest.getter(SearchContactsRequest::timeRange)).setter(SearchContactsRequest.setter(Builder::timeRange)).constructor(SearchContactsTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRange").build()}).build();
    private static final SdkField<SearchCriteria> SEARCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchCriteria").getter(SearchContactsRequest.getter(SearchContactsRequest::searchCriteria)).setter(SearchContactsRequest.setter(Builder::searchCriteria)).constructor(SearchCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchCriteria").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchContactsRequest.getter(SearchContactsRequest::maxResults)).setter(SearchContactsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchContactsRequest.getter(SearchContactsRequest::nextToken)).setter(SearchContactsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Sort> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sort").getter(SearchContactsRequest.getter(SearchContactsRequest::sort)).setter(SearchContactsRequest.setter(Builder::sort)).constructor(Sort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, TIME_RANGE_FIELD, SEARCH_CRITERIA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchContactsRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final SearchContactsTimeRange timeRange;
    private final SearchCriteria searchCriteria;
    private final Integer maxResults;
    private final String nextToken;
    private final Sort sort;

    private SearchContactsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.timeRange = builder.timeRange;
        this.searchCriteria = builder.searchCriteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sort = builder.sort;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final SearchContactsTimeRange timeRange() {
        return this.timeRange;
    }

    public final SearchCriteria searchCriteria() {
        return this.searchCriteria;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Sort sort() {
        return this.sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchContactsRequest)) {
            return false;
        }
        SearchContactsRequest other = (SearchContactsRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.timeRange(), other.timeRange()) && Objects.equals(this.searchCriteria(), other.searchCriteria()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sort(), other.sort());
    }

    public final String toString() {
        return ToString.builder((String)"SearchContactsRequest").add("InstanceId", (Object)this.instanceId()).add("TimeRange", (Object)this.timeRange()).add("SearchCriteria", (Object)this.searchCriteria()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Sort", (Object)this.sort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "TimeRange": {
                return Optional.ofNullable(clazz.cast(this.timeRange()));
            }
            case "SearchCriteria": {
                return Optional.ofNullable(clazz.cast(this.searchCriteria()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("TimeRange", TIME_RANGE_FIELD);
        map.put("SearchCriteria", SEARCH_CRITERIA_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Sort", SORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchContactsRequest, T> g) {
        return obj -> g.apply((SearchContactsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private SearchContactsTimeRange timeRange;
        private SearchCriteria searchCriteria;
        private Integer maxResults;
        private String nextToken;
        private Sort sort;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchContactsRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.timeRange(model.timeRange);
            this.searchCriteria(model.searchCriteria);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sort(model.sort);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final SearchContactsTimeRange.Builder getTimeRange() {
            return this.timeRange != null ? this.timeRange.toBuilder() : null;
        }

        public final void setTimeRange(SearchContactsTimeRange.BuilderImpl timeRange) {
            this.timeRange = timeRange != null ? timeRange.build() : null;
        }

        @Override
        public final Builder timeRange(SearchContactsTimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public final SearchCriteria.Builder getSearchCriteria() {
            return this.searchCriteria != null ? this.searchCriteria.toBuilder() : null;
        }

        public final void setSearchCriteria(SearchCriteria.BuilderImpl searchCriteria) {
            this.searchCriteria = searchCriteria != null ? searchCriteria.build() : null;
        }

        @Override
        public final Builder searchCriteria(SearchCriteria searchCriteria) {
            this.searchCriteria = searchCriteria;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Sort.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(Sort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(Sort sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchContactsRequest build() {
            return new SearchContactsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchContactsRequest> {
        public Builder instanceId(String var1);

        public Builder timeRange(SearchContactsTimeRange var1);

        default public Builder timeRange(Consumer<SearchContactsTimeRange.Builder> timeRange) {
            return this.timeRange((SearchContactsTimeRange)((SearchContactsTimeRange.Builder)SearchContactsTimeRange.builder().applyMutation(timeRange)).build());
        }

        public Builder searchCriteria(SearchCriteria var1);

        default public Builder searchCriteria(Consumer<SearchCriteria.Builder> searchCriteria) {
            return this.searchCriteria((SearchCriteria)((SearchCriteria.Builder)SearchCriteria.builder().applyMutation(searchCriteria)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sort(Sort var1);

        default public Builder sort(Consumer<Sort.Builder> sort) {
            return this.sort((Sort)((Sort.Builder)Sort.builder().applyMutation(sort)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

