/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.EvaluationFormItem;
import software.amazon.awssdk.services.connect.model.EvaluationFormItemsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationFormSection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationFormSection> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(EvaluationFormSection.getter(EvaluationFormSection::title)).setter(EvaluationFormSection.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> REF_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RefId").getter(EvaluationFormSection.getter(EvaluationFormSection::refId)).setter(EvaluationFormSection.setter(Builder::refId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefId").build()}).build();
    private static final SdkField<String> INSTRUCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Instructions").getter(EvaluationFormSection.getter(EvaluationFormSection::instructions)).setter(EvaluationFormSection.setter(Builder::instructions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instructions").build()}).build();
    private static final SdkField<List<EvaluationFormItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(EvaluationFormSection.getter(EvaluationFormSection::items)).setter(EvaluationFormSection.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationFormItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Weight").getter(EvaluationFormSection.getter(EvaluationFormSection::weight)).setter(EvaluationFormSection.setter(Builder::weight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, REF_ID_FIELD, INSTRUCTIONS_FIELD, ITEMS_FIELD, WEIGHT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationFormSection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String refId;
    private final String instructions;
    private final List<EvaluationFormItem> items;
    private final Double weight;

    private EvaluationFormSection(BuilderImpl builder) {
        this.title = builder.title;
        this.refId = builder.refId;
        this.instructions = builder.instructions;
        this.items = builder.items;
        this.weight = builder.weight;
    }

    public final String title() {
        return this.title;
    }

    public final String refId() {
        return this.refId;
    }

    public final String instructions() {
        return this.instructions;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<EvaluationFormItem> items() {
        return this.items;
    }

    public final Double weight() {
        return this.weight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.refId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instructions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormSection)) {
            return false;
        }
        EvaluationFormSection other = (EvaluationFormSection)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.refId(), other.refId()) && Objects.equals(this.instructions(), other.instructions()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.weight(), other.weight());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationFormSection").add("Title", (Object)this.title()).add("RefId", (Object)this.refId()).add("Instructions", (Object)this.instructions()).add("Items", this.hasItems() ? this.items() : null).add("Weight", (Object)this.weight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "RefId": {
                return Optional.ofNullable(clazz.cast(this.refId()));
            }
            case "Instructions": {
                return Optional.ofNullable(clazz.cast(this.instructions()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "Weight": {
                return Optional.ofNullable(clazz.cast(this.weight()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Title", TITLE_FIELD);
        map.put("RefId", REF_ID_FIELD);
        map.put("Instructions", INSTRUCTIONS_FIELD);
        map.put("Items", ITEMS_FIELD);
        map.put("Weight", WEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormSection, T> g) {
        return obj -> g.apply((EvaluationFormSection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String refId;
        private String instructions;
        private List<EvaluationFormItem> items = DefaultSdkAutoConstructList.getInstance();
        private Double weight;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormSection model) {
            this.title(model.title);
            this.refId(model.refId);
            this.instructions(model.instructions);
            this.items(model.items);
            this.weight(model.weight);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getRefId() {
            return this.refId;
        }

        public final void setRefId(String refId) {
            this.refId = refId;
        }

        @Override
        public final Builder refId(String refId) {
            this.refId = refId;
            return this;
        }

        public final String getInstructions() {
            return this.instructions;
        }

        public final void setInstructions(String instructions) {
            this.instructions = instructions;
        }

        @Override
        public final Builder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public final List<EvaluationFormItem.Builder> getItems() {
            List<EvaluationFormItem.Builder> result = EvaluationFormItemsListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<EvaluationFormItem.BuilderImpl> items) {
            this.items = EvaluationFormItemsListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<EvaluationFormItem> items) {
            this.items = EvaluationFormItemsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(EvaluationFormItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<EvaluationFormItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (EvaluationFormItem)((EvaluationFormItem.Builder)EvaluationFormItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getWeight() {
            return this.weight;
        }

        public final void setWeight(Double weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Double weight) {
            this.weight = weight;
            return this;
        }

        public EvaluationFormSection build() {
            return new EvaluationFormSection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationFormSection> {
        public Builder title(String var1);

        public Builder refId(String var1);

        public Builder instructions(String var1);

        public Builder items(Collection<EvaluationFormItem> var1);

        public Builder items(EvaluationFormItem ... var1);

        public Builder items(Consumer<EvaluationFormItem.Builder> ... var1);

        public Builder weight(Double var1);
    }
}

